/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.MoveSelectionCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.Selection;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class MoveVertexCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Point start;
    private EditToolHandler handler;
    private Selection toMove;
    private Point lastPoint;
    private MoveSelectionCommand command;
    private EditState stateAfterSnap;
    private boolean doSnap;
    private SnapBehaviour snapBehaviour;

    public MoveVertexCommand(Point lastPoint, Selection toMove, EditToolHandler handler, Point start, EditState stateAfterSnap, boolean doSnap) {
        this.lastPoint = lastPoint;
        this.toMove = toMove;
        this.handler = handler;
        this.start = start;
        this.stateAfterSnap = stateAfterSnap;
        this.doSnap = doSnap;
        this.snapBehaviour = PreferenceUtil.instance().getSnapBehaviour();
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.command == null) {
            ILayer selectedLayer = this.handler.getEditLayer();
            EditBlackboard editBlackboard = this.handler.getEditBlackboard(selectedLayer);
            Coordinate destinationCoord = null;
            destinationCoord = this.calculateDestinationPoint(editBlackboard, destinationCoord);
            Point dest = editBlackboard.toPoint(destinationCoord);
            int deltaX = dest.getX() - this.lastPoint.getX();
            int deltaY = dest.getY() - this.lastPoint.getY();
            if (deltaX != 0 || deltaY != 0) {
                editBlackboard.moveSelection(deltaX, deltaY, this.toMove);
            }
            editBlackboard.setCoords(dest, destinationCoord);
            deltaX = dest.getX() - this.start.getX();
            deltaY = dest.getY() - this.start.getY();
            this.command = new MoveSelectionCommand(editBlackboard, deltaX, deltaY, this.toMove);
            this.command.setMap((IMap)this.getMap());
        } else {
            this.command.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private Coordinate calculateDestinationPoint(EditBlackboard editBlackboard, Coordinate destinationCoord) {
        if (this.doSnap) {
            destinationCoord = EditUtils.instance.getClosestSnapPoint(this.handler, editBlackboard, this.lastPoint, false, this.snapBehaviour, this.stateAfterSnap);
        }
        if (destinationCoord == null) {
            Point dest = editBlackboard.overVertex(this.lastPoint, PreferenceUtil.instance().getVertexRadius(), true);
            if (dest == null) {
                dest = this.lastPoint;
            }
            destinationCoord = editBlackboard.toCoord(dest);
        }
        return destinationCoord;
    }

    public String getName() {
        return Messages.SnapToVertexCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.command.rollback((IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }
}

