/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Selection;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveSelectionCommand
extends AbstractCommand
implements UndoableCommand {
    private int deltaX;
    private int deltaY;
    private EditBlackboard editBlackboard;
    private Selection selection;

    public MoveSelectionCommand(EditBlackboard editBlackboard, int deltaX, int deltaY, Selection toMove) {
        this.editBlackboard = editBlackboard;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.selection = toMove;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.editBlackboard.moveSelection(-this.deltaX, -this.deltaY, this.selection);
        ((ViewportPane)this.getMap().getRenderManagerInternal().getMapDisplay()).repaint();
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.editBlackboard.moveSelection(this.deltaX, this.deltaY, this.selection);
        ((ViewportPane)this.getMap().getRenderManagerInternal().getMapDisplay()).repaint();
    }

    public String getName() {
        return Messages.MoveSelectionCommand_name;
    }
}

