/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.awt.Color;
import java.awt.Rectangle;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseMotionListener;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditGeomPointIterator;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class DrawPointCommand
extends AbstractDrawCommand
implements MapMouseMotionListener {
    private PrimitiveShape shape;
    private int radius = 2;
    private IProvider<Color> outline = new IProvider<Color>(){

        public Color get(Object ... params) {
            return PreferenceUtil.instance().getDrawVertexLineColor();
        }
    };
    private IProvider<Color> fill = new IProvider<Color>(){

        public Color get(Object ... params) {
            return PreferenceUtil.instance().getDrawVertexFillColor();
        }
    };
    private ViewportPane pane;
    private Point location;
    private int radiusDelta = 1;
    private IProvider<Color> selectionFill = new IProvider<Color>(){

        public Color get(Object ... params) {
            return PreferenceUtil.instance().getDrawSelectionFillColor();
        }
    };
    private boolean overPoint;
    private EditToolHandler handler;
    private boolean drawCurrentShape;
    IPreferenceStore store = EditPlugin.getDefault().getPreferenceStore();

    public DrawPointCommand(EditToolHandler handler2, PrimitiveShape shape, ViewportPane pane) {
        this.shape = shape;
        this.pane = pane;
        pane.addMouseMotionListener((MapMouseMotionListener)this);
        this.handler = handler2;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.handler.getCurrentState() == EditState.MOVING) {
            return;
        }
        if (this.drawCurrentShape) {
            this.shape = this.handler.getCurrentShape();
        }
        if (this.shape == null || this.shape.getNumPoints() == 0) {
            return;
        }
        Rectangle rect = new Rectangle();
        rect.width = this.radius * 2;
        rect.height = this.radius * 2;
        EditGeomPointIterator iter = new EditGeomPointIterator(this.shape.getEditGeom());
        while (iter.hasNext()) {
            this.graphics.setStroke(1, 1);
            Point p = (Point)iter.next();
            if (!(p.getX() >= 0 && p.getX() <= this.display.getWidth() || p.getY() >= 0 && p.getY() <= this.display.getHeight())) continue;
            rect.x = p.getX() - this.radius;
            rect.y = p.getY() - this.radius;
            if (this.overPoint && p == this.shape.getPoint(0)) {
                this.drawOverPoint(rect, this.isSelected(p));
                continue;
            }
            this.setZoomedRect(rect, p, 0);
            boolean selected = this.isSelected(p);
            this.fillVertex(rect, selected);
            if (selected) {
                this.drawOutline(rect, 2, selected);
                continue;
            }
            this.drawOutline(rect, 1, selected);
        }
    }

    private void drawOverPoint(Rectangle rect, boolean selected) {
        if (this.overPoint) {
            Point point = this.shape.getPoint(0);
            rect.x = point.getX() - this.radius;
            rect.y = point.getY() - this.radius;
            this.setZoomedRect(rect, point, this.radiusDelta);
            if (selected) {
                this.graphics.setColor((Color)this.selectionFill.get(new Object[0]));
            } else {
                this.graphics.setColor((Color)this.fill.get(new Object[0]));
            }
            this.graphics.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
            this.drawOutline(rect, 2, selected);
        }
    }

    private void drawOutline(Rectangle rect, int width, boolean selected) {
        this.graphics.setLineWidth(width);
        if (selected) {
            this.graphics.setColor((Color)this.outline.get(new Object[0]));
        } else {
            this.graphics.setColor(PreferenceUtil.reduceTransparency((Color)this.outline.get(new Object[0]), 0.35f));
        }
        this.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    private void fillVertex(Rectangle rect, boolean selected) {
        if (selected) {
            this.graphics.setColor((Color)this.selectionFill.get(new Object[0]));
        } else {
            this.graphics.setColor((Color)this.fill.get(new Object[0]));
        }
        if (selected || this.store.getBoolean("P_FILL_VERTICES") || this.shape.getEditGeom().getShapeType() == ShapeType.POINT) {
            this.graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private boolean isSelected(Point p) {
        return this.shape.getEditBlackboard().getSelection().contains(p);
    }

    public void setDrawCurrentShape(boolean b) {
        this.drawCurrentShape = b;
    }

    private void setZoomedRect(Rectangle rect, Point p, int widthRad) {
        rect.height = rect.width = widthRad * 2 + this.radius * 2;
        int i = this.radius + widthRad;
        rect.x = p.getX() - i;
        rect.y = p.getY() - i;
    }

    private boolean isOverPoint(Point p) {
        int x = -this.radiusDelta - this.radius;
        int max = this.radius + this.radiusDelta;
        while (x < max) {
            int y = -this.radiusDelta - this.radius;
            while (y < max) {
                if (Point.valueOf(p.getX() + x, p.getY() + y).equals(this.location)) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public void setValid(boolean valid) {
        if (!valid) {
            this.pane.removeMouseMotionListener((MapMouseMotionListener)this);
        }
        super.setValid(valid);
    }

    public void mouseMoved(MapMouseEvent event) {
        boolean oldIsOver = this.overPoint;
        this.location = Point.valueOf(event.x, event.y);
        if (this.shape == null || this.shape.getNumPoints() == 0) {
            return;
        }
        Point firstPoint = this.shape.getPoint(0);
        this.overPoint = this.isOverPoint(firstPoint);
        if (this.overPoint != oldIsOver) {
            this.handler.repaint();
        }
    }

    public void mouseDragged(MapMouseEvent event) {
        this.mouseMoved(event);
    }

    public void setCurrentShape(PrimitiveShape shape) {
        if (shape == this.shape) {
            return;
        }
        this.shape = shape;
        this.handler.repaint();
    }

    public int getRadiusDelta() {
        return this.radiusDelta;
    }

    public void setRadiusDelta(int radiusDelta) {
        this.radiusDelta = radiusDelta;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius - this.radiusDelta;
    }

    public PrimitiveShape getGeom() {
        return this.shape;
    }

    public Rectangle getValidArea() {
        if (this.shape != null) {
            return this.shape.getBounds();
        }
        return null;
    }

    public void mouseHovered(MapMouseEvent event) {
    }
}

