/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.awt.Rectangle;
import java.util.List;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.StyleStrategy;
import net.refractions.udig.tools.edit.support.CurrentEditGeomPathIterator;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public class DrawEditGeomsCommand
extends AbstractDrawCommand {
    private StyleStrategy colorStrategy = new StyleStrategy();
    private Point location;
    private PrimitiveShape currentShape;
    private EditToolHandler handler;
    IPreferenceStore store = EditPlugin.getDefault().getPreferenceStore();

    public DrawEditGeomsCommand(EditToolHandler handler) {
        this.handler = handler;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        List<EditGeom> geoms = this.handler.getEditBlackboard(this.handler.getEditLayer()).getGeoms();
        for (EditGeom geom : geoms) {
            if (geom.getShell().getNumPoints() == 0 || geom.getShell().getNumPoints() <= 0) continue;
            CurrentEditGeomPathIterator pathIterator = CurrentEditGeomPathIterator.getPathIterator(geom);
            if (this.currentShape != null && this.currentShape.getEditGeom() == geom) {
                pathIterator.setLocation(this.location, this.currentShape);
            } else {
                pathIterator.setLocation(null, null);
            }
            this.fillPath(geom, pathIterator);
        }
    }

    private void fillPath(EditGeom geom, CurrentEditGeomPathIterator pathIterator) {
        Path shape = pathIterator.toPath((Device)Display.getCurrent());
        try {
            if (this.store.getBoolean("P_FILL_POLYGONS") && geom.getShapeType() == ShapeType.POLYGON) {
                this.colorStrategy.setFillColor(this.graphics, geom, this.handler);
                this.graphics.fillPath(shape);
            }
            this.colorStrategy.setLineColor2(this.graphics, geom, this.handler);
            this.graphics.drawPath(shape);
            this.colorStrategy.setLineColor(this.graphics, geom, this.handler);
            this.graphics.drawPath(shape);
        }
        finally {
            shape.dispose();
        }
    }

    public void setValid(boolean valid) {
        super.setValid(valid);
    }

    public PrimitiveShape getCurrentShape() {
        return this.currentShape;
    }

    public boolean setCurrentLocation(Point l, PrimitiveShape currentShape) {
        boolean result = false;
        if (currentShape != this.currentShape || l != null && !l.equals(this.location)) {
            result = true;
        }
        this.location = l;
        this.currentShape = currentShape;
        return result;
    }

    public Rectangle getValidArea() {
        return null;
    }

    public StyleStrategy getColorizationStrategy() {
        return this.colorStrategy;
    }
}

