/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.tool.edit.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class CreateNewOrSelectExitingFeatureCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Geometry geom;
    private ILayer layer;
    private String fid;
    private boolean createFeature;
    private UndoableMapCommand modifyCommand;
    private SimpleFeature feature;
    private UndoableMapCommand createCommand;

    public CreateNewOrSelectExitingFeatureCommand(String fid2, ILayer layer2, Geometry geom2) {
        this.fid = fid2;
        this.layer = layer2;
        this.geom = geom2;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.CreateOrSetFeature_name, 10);
        monitor.worked(1);
        FeatureStore store = (FeatureStore)this.layer.getResource(FeatureStore.class, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        Filter id = FeatureUtils.id((String)this.fid);
        String typeName = ((SimpleFeatureType)store.getSchema()).getTypeName();
        DefaultQuery query = new DefaultQuery(typeName, id);
        FeatureIterator iter = store.getFeatures((Query)query).features();
        try {
            this.createFeature = !iter.hasNext();
        }
        finally {
            iter.close();
        }
        if (this.createFeature) {
            this.createFeature((IProgressMonitor)new SubProgressMonitor(monitor, 8));
        } else {
            this.modifyFeature((IProgressMonitor)new SubProgressMonitor(monitor, 8));
        }
    }

    private void modifyFeature(IProgressMonitor monitor) throws Exception {
        this.modifyCommand = EditCommandFactory.getInstance().createSetGeomteryCommand(this.fid, this.layer, this.geom);
        this.modifyCommand.setMap((IMap)this.getMap());
        this.modifyCommand.run(monitor);
    }

    private void createFeature(IProgressMonitor monitor) throws Exception {
        Object[] attributeArray = new Object[this.layer.getSchema().getAttributeCount()];
        this.feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.layer.getSchema(), (Object[])attributeArray, (String)"newFeature");
        this.feature.setDefaultGeometry((Object)this.geom);
        this.createCommand = EditCommandFactory.getInstance().createAddFeatureCommand(this.feature, this.layer);
        this.createCommand.setMap((IMap)this.getMap());
        this.createCommand.run(monitor);
    }

    public String getName() {
        return Messages.CreateOrSetFeature_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.createFeature) {
            this.createCommand.rollback(monitor);
        } else {
            this.modifyCommand.rollback(monitor);
        }
    }
}

