/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.util.Collections;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateEditGeomCommand
extends AbstractCommand
implements UndoableMapCommand,
IBlockingProvider<EditGeom> {
    private String fid;
    private EditBlackboard blackboard;
    private EditGeom geom;
    private ShapeType shapeType;

    public CreateEditGeomCommand(EditBlackboard blackboard, String fid) {
        this(blackboard, fid, ShapeType.UNKNOWN);
    }

    public CreateEditGeomCommand(EditBlackboard blackboard, String fid, ShapeType shapeType) {
        this.blackboard = blackboard;
        this.fid = fid;
        this.shapeType = shapeType;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.geom = this.blackboard.newGeom(this.fid, this.shapeType);
    }

    public String getName() {
        return Messages.CreateEditGeomCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.blackboard.removeGeometries(Collections.singleton(this.geom));
    }

    public EditGeom get(IProgressMonitor monitor, Object ... params) {
        return this.geom;
    }

    public IBlockingProvider<EditGeom> getEditGeomProvider() {
        return new EditUtils.StaticEditGeomProvider(this.geom);
    }

    public IBlockingProvider<PrimitiveShape> getShapeProvider() {
        return new ShapeProvider();
    }

    class ShapeProvider
    implements IBlockingProvider<PrimitiveShape> {
        ShapeProvider() {
        }

        public PrimitiveShape get(IProgressMonitor monitor, Object ... params) {
            return CreateEditGeomCommand.this.geom.getShell();
        }
    }
}

