/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.util.Collections;
import java.util.List;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.commands.edit.AddFeatureCommand;
import net.refractions.udig.project.ui.feature.FeaturePanelEntry;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.FeatureEvent;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class CreateDialogAndSelectNewFeature
extends AbstractCommand
implements UndoableMapCommand {
    private Layer layer;
    private SimpleFeature feature;
    private AddFeatureCommand addFeatureCommand;
    private SimpleFeature oldFeature;
    private ILayer oldLayer;
    private EditGeom geom;
    private String oldID;
    private Filter oldSelection;
    private boolean deselectCreatedFeature;
    private List<FeaturePanelEntry> panels;

    public CreateDialogAndSelectNewFeature(EditGeom geom, SimpleFeature feature, ILayer layer, boolean deselectCreatedFeature, List<FeaturePanelEntry> popup) {
        this.layer = (Layer)layer;
        this.feature = feature;
        this.geom = geom;
        this.panels = popup;
        this.deselectCreatedFeature = deselectCreatedFeature;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        final boolean[] create = new boolean[]{false};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                boolean yes;
                create[0] = yes = MessageDialog.openConfirm(null, (String)"New Feature", (String)("Panels available " + CreateDialogAndSelectNewFeature.this.panels.size()));
            }
        });
        if (!create[0]) {
            return;
        }
        monitor.beginTask(this.getName(), 14);
        monitor.worked(2);
        boolean prev = this.layer.eDeliver();
        try {
            this.layer.eSetDeliver(false);
            this.addFeatureCommand = new AddFeatureCommand(this.feature, (ILayer)this.layer);
            this.addFeatureCommand.setMap((IMap)this.getMap());
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 10);
            this.addFeatureCommand.run((IProgressMonitor)subProgressMonitor);
            subProgressMonitor.done();
            this.oldFeature = this.getMap().getEditManager().getEditFeature();
            this.oldLayer = this.getMap().getEditManager().getEditLayer();
            this.oldID = this.geom.getFeatureIDRef().get();
            this.geom.getFeatureIDRef().set(this.addFeatureCommand.getFid());
            this.getMap().getEditManagerInternal().setEditFeature(this.addFeatureCommand.getNewFeature(), this.layer);
            this.oldSelection = this.layer.getFilter();
            Filter filter = FeatureUtils.id((String)this.addFeatureCommand.getFid());
            if (this.deselectCreatedFeature) {
                this.geom.getEditBlackboard().removeGeometries(Collections.singleton(this.geom));
                this.layer.eSetDeliver(prev);
            } else {
                EditUtils.instance.refreshLayer((ILayer)this.layer, Collections.singleton(this.addFeatureCommand.getFid()), null, false, true);
            }
            this.layer.setFilter(filter);
            this.fireFeatureEvent(prev);
        }
        finally {
            this.layer.eSetDeliver(prev);
        }
        monitor.done();
    }

    private void fireFeatureEvent(boolean prev) {
        List featureChanges = this.layer.getFeatureChanges();
        this.layer.eSetDeliver(prev);
        int index = featureChanges.size() - 1;
        FeatureEvent featureEvent = (FeatureEvent)featureChanges.get(index);
        featureChanges.set(index, featureEvent);
    }

    public String getName() {
        return Messages.CreateAndSetNewFeature_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(this.getName(), 14);
        monitor.worked(2);
        boolean prev = this.layer.eDeliver();
        try {
            this.layer.eSetDeliver(false);
            this.layer.setFilter(this.oldSelection);
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 10);
            this.addFeatureCommand.rollback((IProgressMonitor)subProgressMonitor);
            subProgressMonitor.done();
            this.geom.getFeatureIDRef().set(this.oldID);
            this.getMap().getEditManagerInternal().setEditFeature(this.oldFeature, (Layer)this.oldLayer);
            if (this.deselectCreatedFeature) {
                EditBlackboard bb = this.geom.getEditBlackboard();
                EditGeom newGeom = bb.newGeom(this.geom.getFeatureIDRef().get(), this.geom.getShapeType());
                PrimitiveShape shell = this.geom.getShell();
                for (Point point : shell) {
                    bb.addPoint(point.getX(), point.getY(), newGeom.getShell());
                }
                List<PrimitiveShape> holes = this.geom.getHoles();
                for (PrimitiveShape primitiveShape : holes) {
                    PrimitiveShape newHole = newGeom.newHole();
                    for (Point point2 : primitiveShape) {
                        bb.addPoint(point2.getX(), point2.getY(), newHole);
                    }
                }
                this.geom = newGeom;
            } else {
                EditUtils.instance.refreshLayer((ILayer)this.layer, Collections.singleton(this.addFeatureCommand.getFid()), null, false, false);
            }
        }
        finally {
            this.layer.eSetDeliver(prev);
        }
        monitor.done();
    }
}

