/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour.accept;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.StaticBlockingProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.provider.FIDFeatureProvider;
import net.refractions.udig.project.internal.commands.edit.CreateFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.DeleteFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.SetGeometryCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.commands.DrawCommandFactory;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.animation.GeometryOperationAnimation;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.commands.CreateAndSelectNewFeature;
import net.refractions.udig.tools.edit.commands.CreateNewOrSelectExitingFeatureCommand;
import net.refractions.udig.tools.edit.commands.SetEditGeomChangedStateCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditGeomPathIterator;
import net.refractions.udig.tools.edit.support.GeometryCreationUtil;
import net.refractions.udig.tools.edit.support.IsBusyStateProvider;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class AcceptChangesBehaviour
implements Behaviour {
    private final Class<? extends Geometry> geomToCreate;
    private boolean updateBlackboard = true;
    private boolean deselectCreatedFeatures;

    public AcceptChangesBehaviour(Class<? extends Geometry> geomToCreate, boolean deselectCreatedFeatures) {
        if (geomToCreate != Polygon.class && geomToCreate != Point.class && geomToCreate != LineString.class && geomToCreate != LinearRing.class) {
            throw new IllegalArgumentException("Must be one of Polygon, Point, LineString, MultiPoint or LinearRing");
        }
        this.geomToCreate = geomToCreate;
        this.deselectCreatedFeatures = deselectCreatedFeatures;
    }

    @Override
    public boolean isValid(EditToolHandler handler) {
        boolean currentGeomNotNull;
        EditGeom currentGeom = handler.getCurrentGeom();
        boolean bl = currentGeomNotNull = currentGeom != null;
        return currentGeomNotNull && this.typeCanBeAssignedToLayer(handler.getEditLayer().getSchema().getGeometryDescriptor().getType().getBinding());
    }

    private boolean typeCanBeAssignedToLayer(Class type) {
        if (type.isAssignableFrom(this.geomToCreate)) {
            return true;
        }
        if (this.geomToCreate == Polygon.class && type.isAssignableFrom(MultiPolygon.class)) {
            return true;
        }
        if (this.geomToCreate == LinearRing.class && type.isAssignableFrom(MultiLineString.class)) {
            return true;
        }
        if (this.geomToCreate == LineString.class && type.isAssignableFrom(MultiLineString.class)) {
            return true;
        }
        return this.geomToCreate == Point.class && type.isAssignableFrom(MultiPoint.class);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler) {
        Map<String, GeometryCreationUtil.Bag> idToGeom;
        if (!this.isValid(handler)) {
            throw new IllegalArgumentException("Not in a valid state for this to run");
        }
        try {
            idToGeom = GeometryCreationUtil.createAllGeoms(handler.getCurrentGeom(), this.geomToCreate, handler.getEditLayer().getSchema().getGeometryDescriptor(), true);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        if (idToGeom.isEmpty()) {
            return null;
        }
        EditState oldState = handler.getCurrentState();
        ArrayList<UndoableMapCommand> commands = new ArrayList<UndoableMapCommand>();
        commands.add(new SetEditStateCommand(handler, EditState.COMMITTING));
        ILayer layer = handler.getEditLayer();
        Set<Map.Entry<String, GeometryCreationUtil.Bag>> entries = idToGeom.entrySet();
        for (Map.Entry<String, GeometryCreationUtil.Bag> entry : entries) {
            commands.addAll(this.processIntoCommands(handler, layer, entry));
        }
        UndoableComposite composite = new UndoableComposite(commands);
        composite.setName(Messages.WriteChangesBehaviour_commandName);
        composite.getFinalizerCommands().add(new SetEditStateCommand(handler, EditState.MODIFYING));
        handler.setCurrentState(oldState);
        return composite;
    }

    private List<UndoableMapCommand> processIntoCommands(EditToolHandler handler, ILayer layer, Map.Entry<String, GeometryCreationUtil.Bag> entry) {
        IMapDisplay display = handler.getContext().getMapDisplay();
        DrawCommandFactory drawfactory = handler.getContext().getDrawFactory();
        SimpleFeatureType schema = layer.getSchema();
        Class binding = schema.getGeometryDescriptor().getType().getBinding();
        ArrayList<UndoableMapCommand> commands = new ArrayList<UndoableMapCommand>();
        EditGeom editGeom = entry.getValue().geom;
        List<Geometry> geoms = entry.getValue().jts;
        Geometry geom = GeometryCreationUtil.ceateGeometryCollection(geoms, binding);
        if (geom == null) {
            StaticBlockingProvider layerProvider = new StaticBlockingProvider((Object)layer);
            FIDFeatureProvider featureProvider = new FIDFeatureProvider(entry.getKey(), (IBlockingProvider)layerProvider);
            DeleteFeatureCommand deleteFeatureCommand = new DeleteFeatureCommand((IBlockingProvider)featureProvider, (IBlockingProvider)layerProvider);
            commands.add((UndoableMapCommand)deleteFeatureCommand);
        } else {
            if (this.updateBlackboard) {
                this.updateBlackboardGeometry(handler, editGeom, geom, commands);
            }
            GeometryOperationAnimation animation = new GeometryOperationAnimation(EditGeomPathIterator.getPathIterator(editGeom).toShape(), new IsBusyStateProvider(handler));
            UndoableMapCommand startAnimationCommand = drawfactory.createStartAnimationCommand(display, Collections.singletonList(animation));
            commands.add(startAnimationCommand);
            if (this.isCurrentGeometry(handler, editGeom)) {
                if (this.isCreatingNewFeature(handler)) {
                    SimpleFeature feature;
                    schema.getAttributeCount();
                    try {
                        feature = SimpleFeatureBuilder.template((SimpleFeatureType)schema, (String)("newFeature" + new Random().nextInt()));
                        feature.setDefaultGeometry((Object)geom);
                    }
                    catch (IllegalAttributeException e) {
                        throw new IllegalStateException("Could not create an empty " + schema.getTypeName() + ":" + (Object)((Object)e), e);
                    }
                    CreateFeatureCommand.runFeatureCreationInterceptors((Feature)feature);
                    CreateAndSelectNewFeature newFeatureCommand = new CreateAndSelectNewFeature(handler.getCurrentGeom(), feature, layer, this.deselectCreatedFeatures);
                    commands.add(newFeatureCommand);
                } else {
                    SetGeometryCommand setGeometryCommand = new SetGeometryCommand(editGeom.getFeatureIDRef().get(), (IBlockingProvider)new StaticBlockingProvider((Object)layer), "DEFAULT_GEOMETRY", geom);
                    commands.add((UndoableMapCommand)setGeometryCommand);
                }
            } else {
                commands.add(new CreateNewOrSelectExitingFeatureCommand(editGeom.getFeatureIDRef().get(), layer, geom));
            }
            commands.add(new SetEditGeomChangedStateCommand(editGeom, false));
            commands.add(drawfactory.createStopAnimationCommand(display, Collections.singletonList(animation)));
        }
        return commands;
    }

    private boolean isCreatingNewFeature(EditToolHandler handler) {
        return handler.getContext().getEditManager().getEditFeature() == null;
    }

    private boolean isCurrentGeometry(EditToolHandler handler, EditGeom editGeom) {
        return editGeom == handler.getCurrentGeom();
    }

    private void updateBlackboardGeometry(EditToolHandler handler, EditGeom editGeom, Geometry geom, List<UndoableMapCommand> commands) {
        block4: {
            block3: {
                if (handler.getCurrentGeom() != editGeom) break block3;
                if (!Polygon.class.isAssignableFrom(this.geomToCreate)) break block4;
                for (PrimitiveShape shape : editGeom) {
                    if (shape.getNumPoints() <= 0 || shape.getPoint(0).equals(shape.getPoint(shape.getNumPoints() - 1))) continue;
                    commands.add(new AddVertexCommand(handler, editGeom.getEditBlackboard(), shape.getPoint(0)));
                }
                break block4;
            }
            if (editGeom.getShapeType() == ShapeType.POLYGON || editGeom.getShapeType() == ShapeType.UNKNOWN && Polygon.class.isAssignableFrom(this.geomToCreate)) {
                for (PrimitiveShape shape : editGeom) {
                    if (shape.getNumPoints() <= 0 || shape.getPoint(0).equals(shape.getPoint(shape.getNumPoints() - 1))) continue;
                    commands.add(new AddVertexCommand(handler, editGeom.getEditBlackboard(), shape.getPoint(0)));
                }
            }
        }
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    public void setUpdateBlackboard(boolean autoFix) {
        this.updateBlackboard = autoFix;
    }
}

