/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.commands.CreateAndSelectHoleCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;

public class StartHoleCuttingBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean selectedShapeIsPolygon;
        boolean button1Released;
        boolean legalState = true;
        boolean legalEventType = eventType == EventType.RELEASED;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean bl = button1Released = e.button == 8;
        if (!shapeAndGeomNotNull) {
            return false;
        }
        EditGeom currentGeom = handler.getCurrentGeom();
        boolean bl2 = selectedShapeIsPolygon = currentGeom.getShapeType() == ShapeType.POLYGON || currentGeom.getShapeType() == ShapeType.UNKNOWN;
        if (!(legalState && legalEventType && shapeAndGeomNotNull && button1Released && !e.buttonsDown() && !e.modifiersDown() && selectedShapeIsPolygon)) {
            return false;
        }
        Point point = Point.valueOf(e.x, e.y);
        if (!currentGeom.getShell().contains(point, true)) {
            return false;
        }
        for (PrimitiveShape shape : currentGeom.getHoles()) {
            if (!shape.contains(point, true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalStateException("Current state is illegal this method should not be called");
        }
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        commands.add(new SetEditStateCommand(handler, EditState.CREATING));
        commands.add(new CreateAndSelectHoleCommand(handler));
        commands.add(new AddVertexCommand(handler, handler.getEditBlackboard(handler.getEditLayer()), Point.valueOf(e.x, e.y)));
        return new UndoableComposite(commands);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
    }
}

