/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.DeselectEditGeomCommand;
import net.refractions.udig.tools.edit.commands.StartEditingCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class StartEditingBehaviour
implements EventBehaviour {
    private ShapeType type;

    public StartEditingBehaviour(ShapeType type) {
        this.type = type;
    }

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean noButtonsDown;
        boolean goodState = handler.getCurrentState() != EditState.NONE && handler.getCurrentState() == EditState.MODIFYING || handler.getCurrentState() == EditState.NONE && handler.getCurrentState() != EditState.MODIFYING;
        boolean releasedEvent = eventType == EventType.RELEASED;
        boolean noModifiers = !e.modifiersDown();
        boolean button1 = e.button == 8;
        boolean bl = noButtonsDown = !e.buttonsDown();
        return goodState && releasedEvent && noButtonsDown && noModifiers && button1;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Current State is not valid for behaviour");
        }
        ArrayList<UndoableMapCommand> commands = new ArrayList<UndoableMapCommand>();
        commands.add(handler.getContext().getEditFactory().createNullEditFeatureCommand());
        ILayer editLayer = handler.getEditLayer();
        EditBlackboard bb = handler.getEditBlackboard(editLayer);
        commands.add(new DeselectEditGeomCommand(handler, bb.getGeoms()));
        commands.add(new StartEditingCommand(handler, e, this.type));
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        undoableComposite.setMap(handler.getContext().getMap());
        try {
            undoableComposite.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return new UndoRedoCommand((UndoableMapCommand)undoableComposite);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("" + handler, error);
    }
}

