/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;
import net.refractions.udig.tools.edit.commands.SelectVertexCommand;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;

public class SelectVerticesWithBoxBehaviour
implements LockingBehaviour {
    private SelectionBoxCommand drawShapeCommand;
    private SelectBehaviour selectBehaviour;

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean legalModifiers;
        boolean legalState = handler.getCurrentState() != EditState.CREATING;
        boolean legalEventType = eventType == EventType.DRAGGED;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean bl = legalModifiers = e.isShiftDown() || !e.modifiersDown();
        return legalState && legalEventType && shapeAndGeomNotNull && legalModifiers && e.buttons == 8;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (this.selectBehaviour == null) {
            handler.lock(this);
            this.selectBehaviour = new SelectBehaviour();
            handler.getBehaviours().add(this.selectBehaviour);
            this.drawShapeCommand = new SelectionBoxCommand();
            handler.getContext().getViewportPane().addDrawCommand((IDrawCommand)this.drawShapeCommand);
        }
        Point start = handler.getMouseTracker().getDragStarted();
        this.drawShapeCommand.setShape((Shape)new Rectangle(Math.min(start.getX(), e.x), Math.min(start.getY(), e.y), Math.abs(start.getX() - e.x), Math.abs(start.getY() - e.y)));
        handler.repaint();
        return null;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    @Override
    public Object getKey(EditToolHandler handler) {
        return this;
    }

    class SelectBehaviour
    implements LockingBehaviour {
        SelectBehaviour() {
        }

        @Override
        public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            boolean legalEventType = eventType == EventType.RELEASED;
            return legalEventType;
        }

        @Override
        public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            List<EventBehaviour> behaviours = handler.getBehaviours();
            behaviours.remove(SelectVerticesWithBoxBehaviour.this.selectBehaviour);
            SelectVerticesWithBoxBehaviour.this.drawShapeCommand.setValid(false);
            HashSet<Point> points = new HashSet<Point>();
            Rectangle rect = (Rectangle)SelectVerticesWithBoxBehaviour.this.drawShapeCommand.getShape();
            EditGeom geom = handler.getCurrentGeom();
            int x = rect.x;
            int maxx = (int)rect.getMaxX();
            while (x < maxx) {
                int y = rect.y;
                int maxy = (int)rect.getMaxY();
                while (y < maxy) {
                    Point valueOf = Point.valueOf(x, y);
                    if (geom.hasVertex(valueOf)) {
                        points.add(valueOf);
                    }
                    ++y;
                }
                ++x;
            }
            handler.unlock(this);
            SelectVerticesWithBoxBehaviour.this.selectBehaviour = null;
            SelectVerticesWithBoxBehaviour.this.drawShapeCommand = null;
            if (e.isShiftDown()) {
                return new SelectVertexCommand(handler.getCurrentGeom().getEditBlackboard(), points, SelectVertexCommand.Type.ADD);
            }
            return new SelectVertexCommand(handler.getCurrentGeom().getEditBlackboard(), points, SelectVertexCommand.Type.SET);
        }

        @Override
        public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
            EditPlugin.log("", error);
        }

        @Override
        public Object getKey(EditToolHandler handler) {
            return SelectVerticesWithBoxBehaviour.this;
        }
    }
}

