/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.SelectVertexCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.Selection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SelectVertexOnMouseDownBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean overPoint;
        boolean currentGeomNotNull = handler.getCurrentGeom() != null;
        boolean eventTypePressed = eventType == EventType.PRESSED;
        boolean button1Changed = e.button == 8;
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        boolean bl = overPoint = editBlackboard.overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius()) != null;
        return currentGeomNotNull && eventTypePressed && button1Changed && !e.modifiersDown() && e.buttons == 8 && overPoint;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Not valid state", new Exception());
        }
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        Point point = handler.getEditBlackboard(handler.getEditLayer()).overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        List<EditGeom> geoms = null;
        if (point == null) {
            EditPlugin.trace("net.refractions.udig.tools.edit/selection", "VertexSelectorBehaviour: Not over vertex (" + e.x + "," + e.y + ")", null);
            return null;
        }
        geoms = editBlackboard.getGeoms(point.getX(), point.getY());
        Selection selection = editBlackboard.getSelection();
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        if (!selection.contains(point)) {
            commands.add(new SelectVertexCommand(editBlackboard, point, SelectVertexCommand.Type.SET));
        }
        if (geoms != null && geoms.contains(handler.getCurrentGeom()) && handler.getCurrentState() == EditState.NONE) {
            commands.add(new SetEditStateCommand(handler, EditState.MODIFYING));
        }
        if (commands.size() == 0) {
            return null;
        }
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        undoableComposite.setMap(handler.getContext().getMap());
        try {
            undoableComposite.execute((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            throw (RuntimeException)new RuntimeException().initCause(e1);
        }
        return new UndoRedoCommand((UndoableMapCommand)undoableComposite);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }
}

