/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.SelectVertexCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.Selection;

public class SelectVertexBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean button1Changed;
        boolean currentGeomNotNull = handler.getCurrentGeom() != null;
        boolean eventTypePressed = eventType == EventType.RELEASED;
        boolean twoModifiersDown = e.isShiftDown() && e.isControlDown();
        boolean singleModifierDown = !twoModifiersDown;
        boolean altUp = !e.isAltDown();
        boolean bl = button1Changed = (e.button ^ 8) == 0;
        if (!(currentGeomNotNull && eventTypePressed && singleModifierDown && altUp && button1Changed)) {
            return false;
        }
        EditGeom geom = handler.getCurrentGeom();
        return geom.hasVertex(geom.getEditBlackboard().overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius()));
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Not valid state", new Exception());
        }
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        Point point = handler.getEditBlackboard(handler.getEditLayer()).overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        List<EditGeom> geoms = null;
        if (point != null) {
            geoms = editBlackboard.getGeoms(point.getX(), point.getY());
        } else {
            EditPlugin.trace("net.refractions.udig.tools.edit/selection", "VertexSelectorBehaviour: Not over vertex (" + e.x + "," + e.y + ")", null);
        }
        Selection selection = editBlackboard.getSelection();
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        if (e.isShiftDown()) {
            if (geoms != null && geoms.contains(handler.getCurrentGeom()) && !editBlackboard.getSelection().contains(point)) {
                commands.add(new SelectVertexCommand(editBlackboard, point, SelectVertexCommand.Type.ADD));
            }
        } else if (e.isControlDown()) {
            if (geoms != null && geoms.contains(handler.getCurrentGeom())) {
                if (selection.contains(point)) {
                    commands.add(new SelectVertexCommand(editBlackboard, point, SelectVertexCommand.Type.REMOVE));
                } else {
                    commands.add(new SelectVertexCommand(editBlackboard, point, SelectVertexCommand.Type.ADD));
                }
            }
        } else if (selection.size() != 1 || !selection.contains(point)) {
            commands.add(new SelectVertexCommand(editBlackboard, point, SelectVertexCommand.Type.SET));
        }
        if (geoms != null && geoms.contains(handler.getCurrentGeom()) && handler.getCurrentState() == EditState.NONE) {
            commands.add(new SetEditStateCommand(handler, EditState.MODIFYING));
        }
        if (commands.size() == 0) {
            return null;
        }
        return new UndoableComposite(commands);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }
}

