/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.RemoveSelectedVerticesCommand;
import net.refractions.udig.tools.edit.commands.SelectVertexCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;

public class RemoveVertexBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean button1Released;
        boolean legalEventType = eventType == EventType.RELEASED;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean bl = button1Released = e.button == 8;
        return legalEventType && shapeAndGeomNotNull && button1Released && !e.buttonsDown() && !e.modifiersDown() && this.overGeomVertex(handler, e);
    }

    private boolean overGeomVertex(EditToolHandler handler, MapMouseEvent e) {
        Point vertexOver = handler.getEditBlackboard(handler.getEditLayer()).overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        return handler.getCurrentGeom().hasVertex(vertexOver);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalStateException("isValid() return false");
        }
        Point vertexOver = handler.getEditBlackboard(handler.getEditLayer()).overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        UndoableComposite command = new UndoableComposite();
        EditBlackboard bb = handler.getCurrentShape().getEditBlackboard();
        command.getCommands().add(new SelectVertexCommand(bb, vertexOver, SelectVertexCommand.Type.SET));
        command.getCommands().add(new RemoveSelectedVerticesCommand(handler));
        return command;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }
}

