/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;

public class RefreshLayersBehaviour
implements Behaviour {
    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler) {
        List layer = handler.getContext().getMapLayers();
        for (ILayer layer2 : layer) {
            IBlackboard properties = layer2.getBlackboard();
            if (properties.get("EDIT_FILTER_CACHE") == null) continue;
            Envelope env = new Envelope();
            HashSet<String> fids = new HashSet<String>();
            for (EditGeom geom : handler.getEditBlackboard(layer2).getGeoms()) {
                if (env.isNull()) {
                    env.init(geom.getShell().getEnvelope());
                } else {
                    env.expandToInclude(geom.getShell().getEnvelope());
                }
                fids.add(geom.getFeatureIDRef().get());
            }
            EditUtils.instance.refreshLayer(layer2, fids, env, true, false);
        }
        return null;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        ProjectPlugin.log((String)"", (Throwable)error);
    }

    @Override
    public boolean isValid(EditToolHandler handler) {
        List layer = handler.getContext().getMapLayers();
        for (ILayer layer2 : layer) {
            if (layer2.getBlackboard().get("EDIT_FILTER_CACHE") == null) continue;
            return true;
        }
        return false;
    }
}

