/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;
import net.refractions.udig.tools.edit.animation.MessageBubble;
import net.refractions.udig.tools.edit.behaviour.IEditValidator;
import net.refractions.udig.tools.edit.commands.DrawSnapAreaCommand;
import net.refractions.udig.tools.edit.commands.MoveVertexCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.GeometryCreationUtil;
import net.refractions.udig.tools.edit.support.Selection;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import net.refractions.udig.tools.edit.validator.LegalShapeValidator;

public class MoveVertexBehaviour
implements EventBehaviour,
LockingBehaviour {
    PositionTracker tracker;
    DrawSnapAreaCommand drawSnapArea;
    private IProvider<IEditValidator> validatorFactory = new IProvider<IEditValidator>(){

        public IEditValidator get(Object ... params) {
            return new LegalShapeValidator();
        }
    };

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean currentGeomNotNull;
        boolean isLegalState = handler.getCurrentState() == EditState.MODIFYING || handler.getCurrentState() == EditState.NONE || handler.getCurrentState() == EditState.MOVING;
        boolean isEventDragged = eventType == EventType.DRAGGED;
        boolean noModifiersDown = !e.modifiersDown();
        boolean button1IsDown = (e.buttons ^ 8) == 0;
        boolean bl = currentGeomNotNull = handler.getCurrentGeom() != null;
        return isLegalState && isEventDragged && noModifiersDown && button1IsDown && currentGeomNotNull && (handler.isLockOwner(this) || this.startedOverSelectedVertex(handler));
    }

    private boolean startedOverSelectedVertex(EditToolHandler handler) {
        if (this.tracker != null) {
            return true;
        }
        net.refractions.udig.tools.edit.support.Point started = handler.getMouseTracker().getDragStarted();
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        net.refractions.udig.tools.edit.support.Point point = handler.getEditBlackboard(handler.getEditLayer()).overVertex(net.refractions.udig.tools.edit.support.Point.valueOf(started.getX(), started.getY()), PreferenceUtil.instance().getVertexRadius());
        if (point == null) {
            point = net.refractions.udig.tools.edit.support.Point.valueOf(started.getX(), started.getY());
        }
        return this.getPointsToMove(handler, editBlackboard).contains(point);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (handler.getCurrentState() != EditState.MOVING) {
            handler.setCurrentState(EditState.MOVING);
        }
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Not valid state", new Exception());
        }
        EditBlackboard editBlackboard2 = handler.getEditBlackboard(handler.getEditLayer());
        editBlackboard2.startBatchingEvents();
        try {
            if (this.tracker == null) {
                handler.lock(this);
                net.refractions.udig.tools.edit.support.Point closestPoint = editBlackboard2.overVertex(net.refractions.udig.tools.edit.support.Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius(), false);
                HashMap<EditGeom, Boolean> changedStatus = new HashMap<EditGeom, Boolean>();
                for (EditGeom geom : editBlackboard2.getGeoms()) {
                    changedStatus.put(geom, geom.isChanged());
                }
                IEditValidator validator = (IEditValidator)this.validatorFactory.get(new Object[]{handler, e, eventType});
                if (validator.isValid(handler, e, eventType) != null) {
                    validator = null;
                }
                this.tracker = new PositionTracker(closestPoint, handler.getMouseTracker().getDragStarted(), this.getPointsToMove(handler, editBlackboard2), changedStatus, validator);
                handler.getBehaviours().add(this.tracker);
                if (this.isSnappingValid() && PreferenceUtil.instance().getSnapBehaviour() != SnapBehaviour.GRID) {
                    this.drawSnapArea = new DrawSnapAreaCommand(this.tracker);
                    handler.getContext().getViewportPane().addDrawCommand((IDrawCommand)this.drawSnapArea);
                }
            }
            if (this.tracker.lastPoint == null) {
                this.tracker.lastPoint = handler.getMouseTracker().getDragStarted();
            }
            net.refractions.udig.tools.edit.support.Point point = net.refractions.udig.tools.edit.support.Point.valueOf(e.x, e.y);
            int deltaX = point.getX() - this.tracker.lastPoint.getX();
            int deltaY = point.getY() - this.tracker.lastPoint.getY();
            this.doMove(deltaX, deltaY, handler, editBlackboard2, this.tracker.selection);
            this.tracker.lastPoint = point;
            return null;
        }
        finally {
            editBlackboard2.fireBatchedEvents();
            handler.repaint();
        }
    }

    protected void doMove(int deltaX, int deltaY, EditToolHandler handler, EditBlackboard editBlackboard2, Selection selectionToMove) {
        editBlackboard2.moveSelection(deltaX, deltaY, selectionToMove);
    }

    protected boolean isSnappingValid() {
        return PreferenceUtil.instance().getSnapBehaviour() != SnapBehaviour.OFF;
    }

    protected Selection getPointsToMove(EditToolHandler handler, EditBlackboard blackboard) {
        return blackboard.getSelection();
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    @Override
    public Object getKey(EditToolHandler handler) {
        return this;
    }

    public void setValidatorFactory(IProvider<IEditValidator> validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public class PositionTracker
    implements LockingBehaviour,
    IProvider<net.refractions.udig.tools.edit.support.Point> {
        net.refractions.udig.tools.edit.support.Point lastPoint;
        private net.refractions.udig.tools.edit.support.Point start;
        private Selection selection;
        private Map<EditGeom, Boolean> dirtyStatesBeforeMove;
        private IEditValidator validator;

        public PositionTracker(net.refractions.udig.tools.edit.support.Point closestPoint, net.refractions.udig.tools.edit.support.Point dragStarted, Selection selection, Map<EditGeom, Boolean> dirtyStatesBeforeMove, IEditValidator validator) {
            this.selection = selection;
            this.start = this.lastPoint = closestPoint != null ? closestPoint : dragStarted;
            this.dirtyStatesBeforeMove = dirtyStatesBeforeMove;
            this.validator = validator;
        }

        @Override
        public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            return eventType == EventType.RELEASED;
        }

        @Override
        public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            if (MoveVertexBehaviour.this.drawSnapArea != null) {
                MoveVertexBehaviour.this.drawSnapArea.setValid(false);
                MoveVertexBehaviour.this.drawSnapArea = null;
            }
            handler.getBehaviours().remove(this);
            MoveVertexBehaviour.this.tracker = null;
            handler.unlock(this);
            if (this.validator != null) {
                return this.doValidation(handler, e, eventType);
            }
            String errorMessage = this.testToGeometry(handler.getCurrentGeom());
            if (errorMessage != null) {
                this.openErrorBubble(handler, e, errorMessage);
                return new SetEditStateCommand(handler, EditState.MODIFYING);
            }
            return this.createMoveCommand(handler);
        }

        private UndoableMapCommand doValidation(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            String errorMessage = this.validator.isValid(handler, e, eventType);
            if (errorMessage == null) {
                return this.createMoveCommand(handler);
            }
            this.openErrorBubble(handler, e, errorMessage);
            return new SetEditStateCommand(handler, EditState.MODIFYING);
        }

        private String testToGeometry(EditGeom geom) {
            Class<? extends Geometry> type = this.determinGeometryType(geom);
            if (type != null) {
                try {
                    GeometryCreationUtil.createGeom(type, geom.getShell(), false);
                }
                catch (IllegalStateException illegalStateException) {
                    return "Change resulted in an invalid Geometry.\n\nPlease try again";
                }
            }
            return null;
        }

        private Class<? extends Geometry> determinGeometryType(EditGeom geom) {
            switch (geom.getShapeType()) {
                case LINE: {
                    return LineString.class;
                }
                case POINT: {
                    return Point.class;
                }
                case POLYGON: {
                    return Polygon.class;
                }
            }
            return null;
        }

        private void openErrorBubble(EditToolHandler handler, MapMouseEvent e, String errorMessage) {
            MessageBubble bubble = new MessageBubble(e.getPoint().x, e.getPoint().y, errorMessage, PreferenceUtil.instance().getMessageDisplayDelay());
            AnimationUpdater.runTimer((IMapDisplay)handler.getContext().getMapDisplay(), (IAnimation)bubble);
            EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
            MoveVertexBehaviour.this.doMove(this.start.getX() - this.lastPoint.getX(), this.start.getY() - this.lastPoint.getY(), handler, editBlackboard, this.selection);
            Set<Map.Entry<EditGeom, Boolean>> entries = this.dirtyStatesBeforeMove.entrySet();
            for (Map.Entry<EditGeom, Boolean> entry : entries) {
                entry.getKey().setChanged(entry.getValue());
            }
        }

        private UndoableMapCommand createMoveCommand(EditToolHandler handler) {
            UndoableComposite command = new UndoableComposite();
            command.getCommands().add(new MoveVertexCommand(this.lastPoint, this.selection, handler, this.start, EditState.MODIFYING, MoveVertexBehaviour.this.isSnappingValid()));
            command.getFinalizerCommands().add(new SetEditStateCommand(handler, EditState.MODIFYING));
            return command;
        }

        @Override
        public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
            EditPlugin.log("", error);
        }

        public net.refractions.udig.tools.edit.support.Point get(Object ... params) {
            return this.lastPoint;
        }

        @Override
        public Object getKey(EditToolHandler handler) {
            return MoveVertexBehaviour.this;
        }
    }
}

