/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.behaviour.MoveVertexBehaviour;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.Selection;

public class MoveGeometryBehaviour
extends MoveVertexBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean altDown;
        boolean currentGeomNotNull;
        boolean isLegalState = handler.getCurrentState() == EditState.MODIFYING || handler.getCurrentState() == EditState.NONE || handler.getCurrentState() == EditState.MOVING;
        boolean isEventDragged = eventType == EventType.DRAGGED;
        boolean onlyButton1IsDown = (e.buttons ^ 8) == 0;
        boolean bl = currentGeomNotNull = handler.getCurrentGeom() != null;
        if (!(isLegalState && isEventDragged && onlyButton1IsDown && currentGeomNotNull)) {
            return false;
        }
        boolean bl2 = altDown = e.isAltDown() && e.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK) || this.allVerticesSelectedAndWithinGeom(handler) || handler.isLockOwner(this);
        return altDown && (handler.isLockOwner(this) || handler.getCurrentShape().contains(Point.valueOf(e.x, e.y), true));
    }

    private boolean allVerticesSelectedAndWithinGeom(EditToolHandler handler) {
        PrimitiveShape currentShape = handler.getCurrentShape();
        Selection selection = handler.getCurrentGeom().getEditBlackboard().getSelection();
        Point dragStarted = handler.getMouseTracker().getDragStarted();
        if (dragStarted == null) {
            return false;
        }
        for (Point point : currentShape) {
            if (selection.contains(point)) continue;
            return false;
        }
        return currentShape.contains(dragStarted, true);
    }

    @Override
    protected Selection getPointsToMove(EditToolHandler handler, EditBlackboard blackboard) {
        return handler.getCurrentGeom().createSelection();
    }

    @Override
    protected boolean isSnappingValid() {
        return false;
    }
}

