/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.internal.commands.draw.DrawPathCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.commands.CreateAndSelectHoleCommand;
import net.refractions.udig.tools.edit.commands.CreateEditGeomCommand;
import net.refractions.udig.tools.edit.commands.SetCurrentGeomCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PathAdapter;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.opengis.feature.simple.SimpleFeatureType;

public class FreeHandPolygonDrawBehaviour
implements LockingBehaviour {
    private Creator creator;
    private DrawPathCommand drawShapeCommand;
    private ShapeType type = ShapeType.POLYGON;
    private PathAdapter generalPath;
    private DrawPathCommand drawEndPoints;

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean legalButtons;
        boolean draggedEvent = eventType == EventType.DRAGGED;
        boolean bl = legalButtons = e.buttons == 8;
        return draggedEvent && legalButtons;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        UndoableMapCommand command = null;
        if (this.creator == null || this.generalPath == null || this.drawEndPoints == null || this.drawShapeCommand == null) {
            command = this.init(handler, e, eventType);
        }
        this.generalPath.lineTo(e.x, e.y);
        this.updateShapes(handler, e);
        SetEditStateCommand setEditStateCommand = new SetEditStateCommand(handler, EditState.CREATING);
        return this.executeCommand(handler, command, setEditStateCommand);
    }

    private UndoableMapCommand executeCommand(EditToolHandler handler, UndoableMapCommand command2, SetEditStateCommand setEditStateCommand) {
        UndoableMapCommand command = command2;
        if (command != null) {
            ArrayList<UndoableMapCommand> commands = new ArrayList<UndoableMapCommand>();
            commands.add(command);
            commands.add(setEditStateCommand);
            UndoableComposite undoableComposite = new UndoableComposite(commands);
            command = undoableComposite;
        } else {
            command = setEditStateCommand;
        }
        command.setMap(handler.getContext().getMap());
        try {
            command.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return new UndoRedoCommand(command);
    }

    private void updateShapes(EditToolHandler handler, MapMouseEvent e) {
        Point dragStarted = handler.getMouseTracker().getDragStarted();
        if (this.isOverEndPoint(e, PreferenceUtil.instance().getVertexRadius(), dragStarted)) {
            this.drawEndPoints.setFill(PreferenceUtil.instance().getDrawVertexFillColor());
        } else {
            this.drawEndPoints.setFill(null);
        }
        if (this.type == ShapeType.POLYGON) {
            this.drawShapeCommand.line(e.x, e.y, dragStarted.getX(), dragStarted.getY());
        }
        handler.repaint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UndoableMapCommand init(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!handler.isLockOwner(this)) {
            handler.lock(this);
        }
        Point dragStarted = handler.getMouseTracker().getDragStarted();
        if (this.creator != null) {
            handler.getBehaviours().remove(this.creator);
        }
        this.creator = new Creator(dragStarted);
        this.initDrawCommands(handler, dragStarted);
        handler.getBehaviours().add(this.creator);
        ILayer selectedLayer = handler.getEditLayer();
        EditBlackboard editBlackboard = handler.getEditBlackboard(selectedLayer);
        int vertexRadius = PreferenceUtil.instance().getVertexRadius();
        Point nearestPoint = editBlackboard.overVertex(dragStarted, vertexRadius);
        if (nearestPoint == null) {
            nearestPoint = dragStarted;
        }
        this.initShapePath(nearestPoint);
        SimpleFeatureType schema = selectedLayer.getSchema();
        this.determineShapeType(schema);
        if (this.type == ShapeType.POLYGON && EditPlugin.getDefault().getPreferenceStore().getBoolean("P_FILL_POLYGONS")) {
            this.drawShapeCommand.setFill(PreferenceUtil.instance().getDrawGeomsFill());
        }
        EditBlackboard blackboard = editBlackboard;
        PrimitiveShape currentShape = handler.getCurrentShape();
        if (currentShape == null) {
            return this.startNewShape(handler, blackboard);
        }
        if ((currentShape = currentShape.getEditGeom().getShell()).getEditGeom().getShapeType() == ShapeType.LINE) {
            if (currentShape.getNumPoints() > 0 && nearestPoint.equals(currentShape.getPoint(0))) {
                EditUtils.instance.reverseOrder(currentShape);
                return null;
            }
            if (currentShape.getNumPoints() <= 1) return null;
            if (nearestPoint.equals(currentShape.getPoint(currentShape.getNumPoints() - 1))) return null;
            return this.createNewGeom(handler);
        }
        if (currentShape.getEditGeom().getShapeType() == ShapeType.POINT) {
            return this.createNewGeom(handler);
        }
        if (!currentShape.contains(nearestPoint, true)) return this.createNewGeom(handler);
        if (handler.getCurrentGeom().getShell() != currentShape) return this.createNewGeom(handler);
        for (PrimitiveShape hole : handler.getCurrentGeom().getHoles()) {
            if (!hole.contains(nearestPoint, true)) continue;
            return this.createNewGeom(handler);
        }
        this.type = ShapeType.POLYGON;
        handler.getContext().sendSyncCommand((Command)new CreateAndSelectHoleCommand(handler));
        return null;
    }

    private UndoableComposite startNewShape(EditToolHandler handler, EditBlackboard blackboard) {
        ArrayList<Object> commands = new ArrayList<Object>();
        CreateEditGeomCommand createEditGeomCommand = new CreateEditGeomCommand(blackboard, "freeHandDraw", ShapeType.LINE);
        commands.add((Object)createEditGeomCommand);
        class PrimitiveProvider
        implements IBlockingProvider<PrimitiveShape> {
            private final /* synthetic */ CreateEditGeomCommand val$createEditGeomCommand;

            PrimitiveProvider(CreateEditGeomCommand createEditGeomCommand) {
                this.val$createEditGeomCommand = createEditGeomCommand;
            }

            public PrimitiveShape get(IProgressMonitor monitor, Object ... params) {
                return this.val$createEditGeomCommand.get(monitor, new Object[0]).getShell();
            }
        }
        commands.add((Object)new SetCurrentGeomCommand(handler, new PrimitiveProvider(createEditGeomCommand)));
        if (handler.getContext().getEditManager().getEditFeature() != null) {
            commands.add(handler.getContext().getEditFactory().createNullEditFeatureCommand());
        }
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        return undoableComposite;
    }

    private void determineShapeType(SimpleFeatureType schema) {
        this.type = Polygon.class.isAssignableFrom(schema.getGeometryDescriptor().getType().getBinding()) || MultiPolygon.class.isAssignableFrom(schema.getGeometryDescriptor().getType().getBinding()) ? ShapeType.POLYGON : (LineString.class.isAssignableFrom(schema.getGeometryDescriptor().getType().getBinding()) || LinearRing.class.isAssignableFrom(schema.getGeometryDescriptor().getType().getBinding()) || MultiLineString.class.isAssignableFrom(schema.getGeometryDescriptor().getType().getBinding()) ? ShapeType.LINE : ShapeType.UNKNOWN);
    }

    private void initShapePath(Point nearestPoint) {
        this.generalPath = new PathAdapter();
        if (Platform.getOS().equals("linux")) {
            this.generalPath.setPath(new GeneralPath());
        } else {
            this.generalPath.setPath(new Path(this.getDisplay()));
        }
        this.generalPath.moveTo(nearestPoint.getX(), nearestPoint.getY());
        if (this.generalPath.isPath()) {
            this.drawShapeCommand.setPath(this.generalPath.getPath());
        } else {
            this.drawShapeCommand.setPath((Device)Display.getCurrent(), this.generalPath.getPathIterator());
        }
    }

    private void initDrawCommands(EditToolHandler handler, Point dragStarted) {
        if (this.drawShapeCommand == null) {
            this.drawShapeCommand = new DrawPathCommand();
            this.drawShapeCommand.setPaint(PreferenceUtil.instance().getDrawGeomsLine());
            handler.getContext().sendASyncCommand((Command)this.drawShapeCommand);
        }
        if (this.drawEndPoints == null) {
            this.drawEndPoints = new DrawPathCommand();
            int vertexRadius = PreferenceUtil.instance().getVertexRadius();
            Path path = new Path(this.getDisplay());
            int i = vertexRadius + vertexRadius;
            path.addRectangle((float)(dragStarted.getX() - vertexRadius), (float)(dragStarted.getY() - vertexRadius), (float)i, (float)i);
            if (EditPlugin.getDefault().getPreferenceStore().getBoolean("P_FILL_VERTICES")) {
                this.drawEndPoints.setFill(PreferenceUtil.instance().getDrawVertexFillColor());
            }
            this.drawEndPoints.setPath(path);
            handler.getContext().sendASyncCommand((Command)this.drawEndPoints);
        }
    }

    private Device getDisplay() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            return display;
        }
        return Display.getDefault();
    }

    private UndoableMapCommand createNewGeom(EditToolHandler handler) {
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        EditBlackboard editBlackboard = handler.getCurrentShape().getEditBlackboard();
        CreateEditGeomCommand createEditGeomCommand = new CreateEditGeomCommand(editBlackboard, "freeHandDraw" + System.currentTimeMillis(), ShapeType.LINE);
        commands.add(createEditGeomCommand);
        class PrimitiveProvider
        implements IBlockingProvider<PrimitiveShape> {
            private final /* synthetic */ CreateEditGeomCommand val$createEditGeomCommand;

            PrimitiveProvider(CreateEditGeomCommand createEditGeomCommand) {
                this.val$createEditGeomCommand = createEditGeomCommand;
            }

            public PrimitiveShape get(IProgressMonitor monitor, Object ... params) {
                return this.val$createEditGeomCommand.get(monitor, new Object[0]).getShell();
            }
        }
        commands.add(new SetCurrentGeomCommand(handler, new PrimitiveProvider(createEditGeomCommand)));
        return new UndoableComposite(commands);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    @Override
    public Object getKey(EditToolHandler handler) {
        return this;
    }

    boolean isOverEndPoint(MapMouseEvent e, int vertexRadius, Point start) {
        EditUtils.MinFinder finder = new EditUtils.MinFinder(start);
        double dist = finder.dist(Point.valueOf(e.x, e.y));
        boolean b = dist < (double)vertexRadius;
        return b;
    }

    private class Creator
    implements LockingBehaviour {
        private Point start;

        public Creator(Point dragStarted) {
            this.start = dragStarted;
        }

        @Override
        public Object getKey(EditToolHandler handler) {
            return FreeHandPolygonDrawBehaviour.this;
        }

        @Override
        public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            return handler.isLockOwner(this) && eventType == EventType.RELEASED;
        }

        @Override
        public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            try {
                PrimitiveShape shape = handler.getCurrentShape();
                int vertexRadius = PreferenceUtil.instance().getVertexRadius();
                if (FreeHandPolygonDrawBehaviour.this.type == ShapeType.UNKNOWN) {
                    if (FreeHandPolygonDrawBehaviour.this.isOverEndPoint(e, vertexRadius, this.start)) {
                        shape.getEditGeom().setShapeType(ShapeType.POLYGON);
                    } else {
                        shape.getEditGeom().setShapeType(ShapeType.LINE);
                    }
                } else {
                    shape.getEditGeom().setShapeType(FreeHandPolygonDrawBehaviour.this.type);
                }
                if (shape.getEditGeom().getShapeType() == ShapeType.POLYGON) {
                    FreeHandPolygonDrawBehaviour.this.generalPath.close();
                }
                UndoableComposite appendPathToShape = EditUtils.instance.appendPathToShape(handler, FreeHandPolygonDrawBehaviour.this.generalPath.getPathIterator(), shape);
                if (shape.getEditGeom().getShapeType() == ShapeType.POLYGON) {
                    List commands = appendPathToShape.getCommands();
                    AddVertexCommand lastVertexCommand = (AddVertexCommand)((Object)commands.get(commands.size() - 1));
                    AddVertexCommand previousVertexCommand = (AddVertexCommand)((Object)commands.get(commands.size() - 2));
                    EditUtils.MinFinder finder = new EditUtils.MinFinder(lastVertexCommand.getPointToAdd());
                    double dist = finder.dist(previousVertexCommand.getPointToAdd());
                    if (dist < (double)vertexRadius) {
                        commands.remove((Object)previousVertexCommand);
                    }
                }
                if (handler.getCurrentShape() != null) {
                    appendPathToShape.getFinalizerCommands().add(new SetEditStateCommand(handler, EditState.MODIFYING));
                } else {
                    appendPathToShape.getFinalizerCommands().add(new SetEditStateCommand(handler, EditState.CREATING));
                }
                appendPathToShape.setMap(handler.getContext().getMap());
                appendPathToShape.run((IProgressMonitor)new NullProgressMonitor());
                UndoRedoCommand undoRedoCommand = new UndoRedoCommand((UndoableMapCommand)appendPathToShape);
                return undoRedoCommand;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                FreeHandPolygonDrawBehaviour.this.creator = null;
                handler.getBehaviours().remove(this);
                handler.unlock(this);
                FreeHandPolygonDrawBehaviour.this.drawShapeCommand.dispose();
                FreeHandPolygonDrawBehaviour.this.drawShapeCommand = null;
                FreeHandPolygonDrawBehaviour.this.drawEndPoints.dispose();
                FreeHandPolygonDrawBehaviour.this.drawEndPoints = null;
                FreeHandPolygonDrawBehaviour.this.generalPath = null;
            }
        }

        @Override
        public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
            EditPlugin.log("", error);
        }
    }
}

