/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AcceptOnDoubleClickBehaviour
implements EventBehaviour {
    boolean addPoint = true;

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean shapeIsSet;
        boolean goodState = handler.getCurrentState() != EditState.NONE;
        boolean releasedEvent = eventType == EventType.DOUBLE_CLICK;
        boolean noModifiers = !e.modifiersDown();
        boolean button1 = e.button == 8;
        boolean onlyButton1Down = e.buttons - (e.buttons & 8) == 0;
        boolean bl = shapeIsSet = handler.getCurrentShape() != null;
        if (!(shapeIsSet && goodState && releasedEvent && noModifiers && button1 && onlyButton1Down)) {
            return false;
        }
        boolean changedGeom = false;
        for (EditGeom geom : handler.getEditBlackboard(handler.getEditLayer()).getGeoms()) {
            if (!geom.isChanged()) continue;
            changedGeom = true;
            break;
        }
        return changedGeom;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        ArrayList<Object> commands = new ArrayList<Object>();
        if (handler.getCurrentState() == EditState.CREATING && this.addPoint) {
            Point clickPoint = Point.valueOf(e.x, e.y);
            EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
            Point destination = editBlackboard.overVertex(clickPoint, PreferenceUtil.instance().getVertexRadius());
            if (destination == null) {
                AddVertexCommand addVertexCommand = new AddVertexCommand(handler, editBlackboard, clickPoint);
                try {
                    addVertexCommand.setMap(handler.getContext().getMap());
                    addVertexCommand.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e1) {
                    throw (RuntimeException)new RuntimeException().initCause(e1);
                }
                commands.add(new UndoRedoCommand((UndoableMapCommand)addVertexCommand));
            }
        }
        commands.add((Object)handler.getCommand(handler.getAcceptBehaviours()));
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        return undoableComposite;
    }

    public boolean isAddPoint() {
        return this.addPoint;
    }

    public void setAddPoint(boolean addPoint) {
        this.addPoint = addPoint;
    }
}

