/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AcceptBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean button1Released;
        boolean legalState = handler.getCurrentState() == EditState.CREATING;
        boolean legalEventType = eventType == EventType.RELEASED;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean bl = button1Released = e.button == 8;
        return legalState && legalEventType && shapeAndGeomNotNull && button1Released && !e.buttonsDown() && !e.modifiersDown();
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Current state is not legal");
        }
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        commands.add(handler.getCommand(handler.getAcceptBehaviours()));
        if (handler.getCurrentState() == EditState.CREATING) {
            commands.add(new SetEditStateCommand(handler, EditState.MODIFYING));
        }
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        undoableComposite.setMap(handler.getContext().getMap());
        try {
            undoableComposite.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return new UndoRedoCommand((UndoableMapCommand)undoableComposite);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }
}

