/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.animation;

import java.awt.Rectangle;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tools.edit.animation.AbstractLongRunningAnimation;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;

public class SearchBoxAnimation
extends AbstractLongRunningAnimation
implements IAnimation {
    protected Point center;
    private long start;

    public SearchBoxAnimation(Point center, IProvider<Boolean> isValidProvider) {
        super(PreferenceUtil.instance().getSnappingRadius(), isValidProvider);
        this.center = center;
        this.start = System.currentTimeMillis();
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.graphics.setColor(PreferenceUtil.instance().getFeedbackColor());
        int radius = PreferenceUtil.instance().getSnappingRadius();
        this.graphics.drawOval(this.center.getX() - radius, this.center.getY() - radius, radius * 2, radius * 2);
        this.graphics.drawOval(this.center.getX() - this.frame, this.center.getY() - this.frame, this.frame * 2, this.frame * 2);
    }

    public short getFrameInterval() {
        return 50;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && System.currentTimeMillis() - this.start < 10000L;
    }

    public Rectangle getValidArea() {
        int radius = PreferenceUtil.instance().getSnappingRadius() + 1;
        return new Rectangle(this.center.getX() - radius, this.center.getY() - radius, radius + radius, radius + radius);
    }
}

