/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.animation;

import java.awt.Rectangle;
import java.awt.Shape;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteVertexAnimation
extends AbstractDrawCommand
implements IAnimation {
    private int frame = 0;
    Point center;

    public DeleteVertexAnimation(Point point) {
        this.center = point;
    }

    public short getFrameInterval() {
        return 50;
    }

    public void nextFrame() {
        ++this.frame;
    }

    public boolean hasNext() {
        return this.frame < 6;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.graphics.setColor(PreferenceUtil.instance().getFeedbackColor());
        int a = this.frame * 4;
        int c = (int)Math.sqrt(a * a + a * a);
        int x = this.center.getX();
        int y = this.center.getY();
        int rad = 3;
        this.graphics.fill((Shape)new Rectangle(x - c, y, rad, rad));
        this.graphics.fill((Shape)new Rectangle(x + c, y, rad, rad));
        this.graphics.fill((Shape)new Rectangle(x, y + c, rad, rad));
        this.graphics.fill((Shape)new Rectangle(x, y - c, rad, rad));
        this.graphics.fill((Shape)new Rectangle(x - a, y - a, rad, rad));
        this.graphics.fill((Shape)new Rectangle(x + a, y - a, rad, rad));
        this.graphics.fill((Shape)new Rectangle(x + a, y + a, rad, rad));
        this.graphics.fill((Shape)new Rectangle(x - a, y + a, rad, rad));
    }

    public Rectangle getValidArea() {
        int a = this.frame * 4;
        int c = (int)Math.sqrt(a * a + a * a);
        int x = this.center.getX();
        int y = this.center.getY();
        return new Rectangle(x - c, y - c, c + c, c + c);
    }
}

