/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.activator;

import java.io.IOException;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.mapgraphic.grid.GridMapGraphic;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.SetLayerVisibilityCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.commands.AddLayerCommand;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import net.refractions.udig.ui.ProgressManager;

public class GridActivator
implements Activator {
    private static final String KEY = "GRID_ACTIVATOR_INDICATOR";

    public void hideGrid(IMap map) {
        ILayer gridLayer = this.findGridLayer(map);
        if (gridLayer != null && gridLayer.getBlackboard().get(KEY) != null) {
            this.setGridLayerVisibility(gridLayer, false);
        }
    }

    public void showGrid(IMap map) {
        ILayer gridLayer = this.findGridLayer(map);
        if (gridLayer != null) {
            this.setGridLayerVisibility(gridLayer, true);
        } else {
            this.addLayer(map);
        }
    }

    @Override
    public void activate(EditToolHandler handler) {
        if (PreferenceUtil.instance().getSnapBehaviour() == SnapBehaviour.GRID) {
            IMap map = handler.getContext().getMap();
            this.showGrid(map);
        }
    }

    @Override
    public void handleDeactivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("", error);
    }

    @Override
    public void handleActivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("", error);
    }

    @Override
    public void deactivate(EditToolHandler handler) {
        if (PreferenceUtil.instance().getSnapBehaviour() == SnapBehaviour.GRID) {
            IMap map = handler.getContext().getMap();
            this.hideGrid(map);
        }
    }

    private void addLayer(IMap map) {
        MapGraphicService service = (MapGraphicService)CatalogPlugin.getDefault().getLocalCatalog().getById(MapGraphicService.class, MapGraphicService.SERVICE_ID, ProgressManager.instance().get(new Object[0]));
        try {
            List members = service.resources(ProgressManager.instance().get(new Object[0]));
            for (IGeoResource resource : members) {
                if (!resource.canResolve(GridMapGraphic.class)) continue;
                LayerFactory factory = map.getLayerFactory();
                Layer newLayer = factory.createLayer(resource);
                newLayer.getBlackboard().put(KEY, (Object)KEY);
                AddLayerCommand command = new AddLayerCommand(newLayer);
                map.sendCommandASync((MapCommand)command);
            }
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    private void setGridLayerVisibility(ILayer gridLayer, boolean enabled) {
        if (enabled != gridLayer.isVisible()) {
            if (enabled) {
                gridLayer.getBlackboard().putString(KEY, KEY);
            }
            gridLayer.getMap().sendCommandASync((MapCommand)new SetLayerVisibilityCommand(gridLayer, enabled));
        }
    }

    private ILayer findGridLayer(IMap map) {
        List layers = map.getMapLayers();
        ILayer graphicLayer = null;
        for (ILayer layer : layers) {
            if (!layer.hasResource(GridMapGraphic.class)) continue;
            graphicLayer = layer;
            break;
        }
        return graphicLayer;
    }
}

