/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.activator;

import java.awt.Color;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseMotionListener;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.DrawEditGeomsCommand;
import net.refractions.udig.tools.edit.commands.StyleStrategy;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;

public class DrawGeomsActivator
implements Activator {
    protected DrawEditGeomsCommand command;
    private DrawType type;
    private boolean showMouseLocation = true;
    private MapMouseMotionListener listener;
    protected ViewportPane pane;
    protected EditToolHandler handler;
    private IBlackboardListener mapBBListener;

    public boolean isShowMouseLocation() {
        return this.showMouseLocation;
    }

    public void setShowMouseLocation(boolean showMouseLocation) {
        this.showMouseLocation = showMouseLocation;
    }

    public DrawGeomsActivator(DrawType type) {
        this.type = type;
    }

    @Override
    public void activate(EditToolHandler handler) {
        this.handler = handler;
        this.command = new DrawEditGeomsCommand(handler);
        StyleStrategy colorizationStrategy = this.command.getColorizationStrategy();
        colorizationStrategy.setFill(new IProvider<Color>(){

            public Color get(Object ... params) {
                return PreferenceUtil.instance().getDrawGeomsFill();
            }
        });
        colorizationStrategy.setLine(new IProvider<Color>(){

            public Color get(Object ... params) {
                return PreferenceUtil.instance().getDrawGeomsLine();
            }
        });
        this.pane = handler.getContext().getViewportPane();
        this.addMouseListener();
        handler.getContext().getViewportPane().addDrawCommand((IDrawCommand)this.command);
    }

    private void removeMouseListener() {
        if (this.pane != null && this.listener != null) {
            this.pane.removeMouseMotionListener(this.listener);
        }
        this.listener = null;
        this.handler.getContext().getMap().getBlackboard().removeListener(this.mapBBListener);
    }

    protected void addMouseListener() {
        this.listener = new MapMouseMotionListener(){

            public void mouseMoved(MapMouseEvent event) {
                if (DrawGeomsActivator.this.type == DrawType.POINT || !DrawGeomsActivator.this.showMouseLocation) {
                    return;
                }
                if (DrawGeomsActivator.this.listener != this) {
                    ((ViewportPane)event.source).removeMouseMotionListener((MapMouseMotionListener)this);
                }
                boolean change = false;
                change = DrawGeomsActivator.this.handler.getCurrentState() == EditState.CREATING ? DrawGeomsActivator.this.command.setCurrentLocation(Point.valueOf(event.x, event.y), DrawGeomsActivator.this.handler.getCurrentShape()) : DrawGeomsActivator.this.command.setCurrentLocation(null, null);
                if (change) {
                    DrawGeomsActivator.this.handler.repaint();
                }
            }

            public void mouseDragged(MapMouseEvent event) {
                this.mouseMoved(event);
            }

            public void mouseHovered(MapMouseEvent event) {
            }
        };
        this.pane.addMouseMotionListener(this.listener);
        this.mapBBListener = new IBlackboardListener(){

            public void blackBoardCleared(IBlackboard source) {
                if (DrawGeomsActivator.this.mapBBListener != this) {
                    source.removeListener((IBlackboardListener)this);
                }
                DrawGeomsActivator.this.command.setCurrentLocation(null, null);
            }

            public void blackBoardChanged(BlackboardEvent event) {
                if (DrawGeomsActivator.this.mapBBListener != this) {
                    event.getSource().removeListener((IBlackboardListener)this);
                }
                if ("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839".equals(event.getKey())) {
                    DrawGeomsActivator.this.command.setCurrentLocation(null, (PrimitiveShape)event.getNewValue());
                }
            }
        };
        this.handler.getContext().getMap().getBlackboard().addListener(this.mapBBListener);
    }

    @Override
    public void deactivate(EditToolHandler handler) {
        if (this.command != null) {
            this.command.setValid(false);
        }
        this.mapBBListener = null;
        this.listener = null;
        this.removeMouseListener();
    }

    @Override
    public void handleActivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("Error creating and sending command", error);
    }

    @Override
    public void handleDeactivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("Error invalidating command", error);
    }

    public static enum DrawType {
        POLYGON,
        LINE,
        POINT;

    }
}

