/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.activator;

import java.util.List;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.DrawPointCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditBlackboardAdapter;
import net.refractions.udig.tools.edit.support.EditBlackboardEvent;
import net.refractions.udig.tools.edit.support.EditBlackboardListener;

public class DrawCurrentGeomVerticesActivator
implements Activator {
    protected DrawPointCommand command;
    protected IBlackboardListener mapBBlistener = new IBlackboardListener(){

        public void blackBoardChanged(BlackboardEvent event) {
            if (event.getSource() != DrawCurrentGeomVerticesActivator.this.handler.getContext().getMap().getBlackboard()) {
                event.getSource().removeListener((IBlackboardListener)this);
                return;
            }
            if (event.getKey() == "EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839" || event.getKey().equals("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839") || event.getKey() == "EDIT_TOOL_HANDLER_EDIT_STATE_KEY_33847562") {
                DrawCurrentGeomVerticesActivator.this.handler.repaint();
            }
        }

        public void blackBoardCleared(IBlackboard source) {
            DrawCurrentGeomVerticesActivator.this.handler.repaint();
        }
    };
    protected EditToolHandler handler;
    protected EditBlackboardListener editBBListener = new EditBlackboardAdapter(){

        @Override
        public void changed(EditBlackboardEvent e) {
            if (e.getEditBlackboard() != DrawCurrentGeomVerticesActivator.this.handler.getEditBlackboard(DrawCurrentGeomVerticesActivator.this.handler.getEditLayer()) && e.getSource() instanceof EditBlackboard) {
                EditBlackboard bb = (EditBlackboard)e.getSource();
                bb.getListeners().remove(this);
                return;
            }
            if (e.getType() == EditBlackboardEvent.EventType.SELECTION) {
                DrawCurrentGeomVerticesActivator.this.handler.repaint();
            }
        }

        @Override
        public void batchChange(List<EditBlackboardEvent> e) {
            for (EditBlackboardEvent event : e) {
                if (event.getEditBlackboard() != DrawCurrentGeomVerticesActivator.this.handler.getEditBlackboard(DrawCurrentGeomVerticesActivator.this.handler.getEditLayer())) {
                    EditBlackboard bb = (EditBlackboard)event.getSource();
                    bb.getListeners().remove(this);
                    return;
                }
                if (event.getType() != EditBlackboardEvent.EventType.SELECTION || DrawCurrentGeomVerticesActivator.this.handler.getCurrentShape() == null) continue;
                DrawCurrentGeomVerticesActivator.this.handler.repaint();
                break;
            }
        }
    };
    protected IEditManagerListener editManagerListener = new IEditManagerListener(){

        public void changed(EditManagerEvent event) {
            if (event.getSource() != DrawCurrentGeomVerticesActivator.this.handler.getContext().getEditManager()) {
                event.getSource().removeListener((IEditManagerListener)this);
                return;
            }
            if (event.getType() == 5 && event.getOldValue() != event.getNewValue()) {
                ILayer layer;
                if (event.getOldValue() != null) {
                    layer = (ILayer)event.getOldValue();
                    DrawCurrentGeomVerticesActivator.this.handler.getEditBlackboard(layer).getListeners().remove(DrawCurrentGeomVerticesActivator.this.editBBListener);
                }
                if (event.getNewValue() != null) {
                    layer = (ILayer)event.getNewValue();
                    DrawCurrentGeomVerticesActivator.this.handler.getEditBlackboard(layer).getListeners().add(DrawCurrentGeomVerticesActivator.this.editBBListener);
                    DrawCurrentGeomVerticesActivator.this.handler.repaint();
                }
            }
        }
    };

    @Override
    public void activate(EditToolHandler handler) {
        this.handler = handler;
        this.command = new DrawPointCommand(handler, handler.getCurrentShape(), handler.getContext().getViewportPane());
        this.command.setRadius(PreferenceUtil.instance().getVertexRadius());
        this.command.setDrawCurrentShape(true);
        handler.getContext().getViewportPane().addDrawCommand((IDrawCommand)this.command);
        handler.getContext().getMap().getEditManager().addListener(this.editManagerListener);
        handler.getContext().getMap().getBlackboard().addListener(this.mapBBlistener);
        handler.getEditBlackboard(handler.getEditLayer()).getListeners().add(this.editBBListener);
    }

    @Override
    public void deactivate(EditToolHandler handler) {
        this.command.setValid(false);
        IMap map = handler.getContext().getMap();
        map.getBlackboard().removeListener(this.mapBBlistener);
        map.getEditManager().removeListener(this.editManagerListener);
        handler.getEditBlackboard(handler.getEditLayer()).getListeners().remove(this.editBBListener);
    }

    @Override
    public void handleActivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("Unexpected Error while activating", error);
        if (this.command != null) {
            this.command.setValid(false);
        }
        handler.getContext().getMap().getBlackboard().removeListener(this.mapBBlistener);
    }

    @Override
    public void handleDeactivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("Unexpected Error while deactivating", error);
        if (this.command != null) {
            this.command.setValid(false);
        }
        handler.getContext().getMap().getBlackboard().removeListener(this.mapBBlistener);
    }
}

