/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventBehaviourCommand;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;

public class OrderedCompositeEventBehavior
implements EventBehaviour,
LockingBehaviour {
    private List<EventBehaviour> modes = new ArrayList<EventBehaviour>();
    private boolean processAsCommand;
    private static final Object NULL_KEY = new Object();

    public OrderedCompositeEventBehavior(List<EventBehaviour> modes, boolean processAsCommand) {
        this.modes = modes;
        this.processAsCommand = processAsCommand;
    }

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (this.processAsCommand) {
            return true;
        }
        for (EventBehaviour mode : this.modes) {
            if (!mode.isValid(handler, e, eventType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (this.processAsCommand) {
            return new EventBehaviourCommand(this.modes, handler, e, eventType);
        }
        UndoableComposite command = new UndoableComposite();
        for (EventBehaviour mode : this.modes) {
            UndoableMapCommand command2;
            if (!mode.isValid(handler, e, eventType) || (command2 = mode.getCommand(handler, e, eventType)) == null) continue;
            command.getCommands().add(command2);
        }
        return command;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("Very Strange I don't know how this happenned...", error);
    }

    @Override
    public Object getKey(EditToolHandler handler) {
        for (EventBehaviour behaviour : this.modes) {
            LockingBehaviour locker;
            if (!(behaviour instanceof LockingBehaviour) || !handler.isLockOwner(locker = (LockingBehaviour)behaviour)) continue;
            return locker.getKey(handler);
        }
        return NULL_KEY;
    }

    public String toString() {
        return this.modes.toString();
    }
}

