/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class MouseTracker {
    private static final int MAX_QUEUE_SIZE = 10;
    private Point dragStarted;
    private Queue<MapMouseEvent> previousEvents = new ConcurrentLinkedQueue<MapMouseEvent>();
    private Point currentPoint;
    private volatile Set<EventType> updateTriggers = new HashSet<EventType>();
    private EditToolHandler handler;

    public MouseTracker(EditToolHandler handler2) {
        this.handler = handler2;
    }

    protected void updateState(MapMouseEvent e, EventType type) {
        this.checkAccess();
        this.previousEvents.add(e);
        if (this.previousEvents.size() > 10) {
            this.previousEvents.remove();
        }
        switch (type) {
            case PRESSED: {
                break;
            }
            case DRAGGED: {
                this.currentPoint = Point.valueOf(e.x, e.y);
                break;
            }
            case DOUBLE_CLICK: {
                break;
            }
            case ENTERED: {
                break;
            }
            case EXITED: {
                break;
            }
            case MOVED: {
                this.currentPoint = this.dragStarted = Point.valueOf(e.x, e.y);
                break;
            }
            case RELEASED: {
                break;
            }
        }
        if (this.updateTriggers.contains((Object)type) && e.source instanceof ViewportPane) {
            this.handler.repaint();
        }
    }

    private void checkAccess() {
        if (Display.getCurrent() == null) {
            SWT.error((int)22);
        }
    }

    public Point getDragStarted() {
        this.checkAccess();
        return this.dragStarted;
    }

    public Queue<MapMouseEvent> getPreviousEvents() {
        this.checkAccess();
        return new LinkedList<MapMouseEvent>(this.previousEvents);
    }

    protected void setDragStarted(Point dragStarted) {
        this.checkAccess();
        this.dragStarted = dragStarted;
    }

    protected Queue<MapMouseEvent> getModifiablePreviousEvents() {
        this.checkAccess();
        return this.previousEvents;
    }

    public Point getCurrentPoint() {
        this.checkAccess();
        return this.currentPoint;
    }
}

