/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.BehaviourCommand;
import net.refractions.udig.tools.edit.EditBlackboardUtil;
import net.refractions.udig.tools.edit.EditManagerListener;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;
import net.refractions.udig.tools.edit.MouseTracker;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class EditToolHandler {
    public static final String EDITSTATE = "EDIT_TOOL_HANDLER_EDIT_STATE_KEY_33847562";
    private static final String LOCK = "EDIT_TOOL_HANDLER_LOCK_KEY_345280194";
    public static final String CURRENT_SHAPE = "EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839";
    public static final String STORED_CURRENT_STATE = "STORED_CURRENT_STATE";
    public static final String STORED_CURRENT_SHAPE = "STORED_CURRENT_SHAPE";
    public final Cursor selectionCursor;
    public final Cursor editCursor;
    private List<EventBehaviour> behaviour = new CopyOnWriteArrayList<EventBehaviour>();
    private List<EnablementBehaviour> enablementBehaviours = new CopyOnWriteArrayList<EnablementBehaviour>();
    private List<Behaviour> acceptBehaviours = new CopyOnWriteArrayList<Behaviour>();
    private List<Behaviour> cancelBehaviours = new CopyOnWriteArrayList<Behaviour>();
    private Set<Activator> activators = new CopyOnWriteArraySet<Activator>();
    private List<IDrawCommand> drawCommands = Collections.synchronizedList(new ArrayList());
    private IToolContext context;
    private MouseTracker mouseTracker = new MouseTracker(this);
    protected boolean testing = false;
    protected AbstractEditTool tool;
    Object behaviourLock;
    private volatile boolean needRepaint;
    private volatile boolean processingEvent;
    private EditState oldState;

    public EditToolHandler(Cursor selectionCursor, Cursor editCursor) {
        this.selectionCursor = selectionCursor;
        this.editCursor = editCursor;
    }

    protected void setActive(boolean active) {
        if (active) {
            this.oldState = EditState.NONE;
            ILayer editLayer = this.getEditLayer();
            if (!this.getEditBlackboard(editLayer).getGeoms().contains(this.getCurrentGeom())) {
                this.setCurrentShape(null);
            }
            this.basicEnablement();
            this.enableListeners();
        } else {
            this.basicDisablement();
            this.disableListeners();
            List<Behaviour> list = this.acceptBehaviours;
            BehaviourCommand command = this.getCommand(list);
            this.getContext().sendASyncCommand((Command)command);
            this.setCurrentState(EditState.NONE);
        }
    }

    void basicDisablement() {
        for (Activator runnable : this.activators) {
            try {
                runnable.deactivate(this);
            }
            catch (Throwable error) {
                runnable.handleDeactivateError(this, error);
            }
        }
        EditUtils.instance.clearLayerStateShapeCache(this.getContext().getMapLayers());
        for (IDrawCommand drawCommand : this.drawCommands) {
            drawCommand.setValid(false);
        }
        this.drawCommands.clear();
    }

    private void disableListeners() {
        EditBlackboardUtil.doneListening();
        EditBlackboardUtil.disableClearBlackboardCommand();
    }

    void basicEnablement() {
        for (Activator runnable : this.activators) {
            try {
                runnable.activate(this);
            }
            catch (Throwable error) {
                runnable.handleActivateError(this, error);
            }
        }
    }

    private void enableListeners() {
        EditManagerListener.enableEditManagerListener(this);
        EditBlackboardUtil.enableClearBlackboardCommand(this.context);
    }

    public BehaviourCommand getCommand(List<Behaviour> list) {
        return new BehaviourCommand(list, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleEvent(MapMouseEvent e, EventType eventType) {
        EditToolHandler editToolHandler = this;
        synchronized (editToolHandler) {
            this.needRepaint = false;
            this.processingEvent = true;
        }
        try {
            block22: {
                block21: {
                    if (this.getCurrentState() == EditState.BUSY) break block21;
                    this.runEnablementBehaviours(e, eventType);
                    if (this.getCurrentState() != EditState.ILLEGAL) break block22;
                }
                EditToolHandler editToolHandler2 = this;
                synchronized (editToolHandler2) {
                    if (this.needRepaint) {
                        this.getContext().getViewportPane().repaint();
                    }
                    this.needRepaint = false;
                    this.processingEvent = false;
                    return;
                }
            }
            this.mouseTracker.updateState(e, eventType);
            this.runEventBehaviours(e, eventType);
        }
        catch (Throwable throwable) {
            EditToolHandler editToolHandler3 = this;
            synchronized (editToolHandler3) {
                if (this.needRepaint) {
                    this.getContext().getViewportPane().repaint();
                }
                this.needRepaint = false;
                this.processingEvent = false;
                throw throwable;
            }
        }
        EditToolHandler editToolHandler4 = this;
        synchronized (editToolHandler4) {
            if (this.needRepaint) {
                this.getContext().getViewportPane().repaint();
            }
            this.needRepaint = false;
            this.processingEvent = false;
            return;
        }
    }

    private void runEnablementBehaviours(MapMouseEvent e, EventType eventType) {
        String errorMessage = null;
        for (EnablementBehaviour b : this.enablementBehaviours) {
            errorMessage = b.isEnabled(this, e, eventType);
            if (errorMessage != null) break;
        }
        if (errorMessage == null) {
            if (this.getCurrentState() == EditState.ILLEGAL) {
                this.setCurrentState(this.oldState);
                this.getContext().getActionBars().getStatusLineManager().setErrorMessage(errorMessage);
            }
        } else {
            this.getContext().getActionBars().getStatusLineManager().setErrorMessage(errorMessage);
            if (this.getCurrentState() != EditState.ILLEGAL) {
                this.oldState = this.getCurrentState();
                this.setCurrentState(EditState.ILLEGAL);
            }
        }
    }

    private void runEventBehaviours(MapMouseEvent e, EventType eventType) {
        for (EventBehaviour b : this.behaviour) {
            if (!this.canUnlock(b) || !b.isValid(this, e, eventType)) continue;
            UndoableMapCommand c = null;
            c = b.getCommand(this, e, eventType);
            if (c == null) continue;
            if (this.testing) {
                c.setMap((IMap)((Map)this.getContext().getMap()));
                try {
                    NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                    c.run((IProgressMonitor)nullProgressMonitor);
                    continue;
                }
                catch (Exception e1) {
                    throw (RuntimeException)new RuntimeException().initCause(e1);
                }
            }
            this.getContext().sendASyncCommand((Command)c);
        }
    }

    private boolean canUnlock(EventBehaviour behaviour) {
        if (!this.isLocked()) {
            return true;
        }
        if (behaviour instanceof LockingBehaviour) {
            LockingBehaviour locker = (LockingBehaviour)behaviour;
            return this.behaviourLock == locker.getKey(this);
        }
        return false;
    }

    public EditGeom getCurrentGeom() {
        Lock lock2 = this.getLock();
        lock2.lock();
        try {
            PrimitiveShape currentShape = this.getCurrentShape();
            EditGeom editGeom = currentShape == null ? null : currentShape.getEditGeom();
            return editGeom;
        }
        finally {
            lock2.unlock();
        }
    }

    public void setCurrentShape(PrimitiveShape currentShape) {
        Lock lock2 = this.getLock();
        lock2.lock();
        try {
            this.getContext().getMap().getBlackboard().put(CURRENT_SHAPE, (Object)currentShape);
        }
        finally {
            lock2.unlock();
        }
    }

    public PrimitiveShape getCurrentShape() {
        Lock lock2 = this.getLock();
        lock2.lock();
        try {
            PrimitiveShape primitiveShape = (PrimitiveShape)this.getContext().getMap().getBlackboard().get(CURRENT_SHAPE);
            return primitiveShape;
        }
        finally {
            lock2.unlock();
        }
    }

    public EditState getCurrentState() {
        Lock lock2 = this.getLock();
        lock2.lock();
        try {
            EditState editState2 = (EditState)((Object)this.getContext().getMap().getBlackboard().get(EDITSTATE));
            EditState editState = editState2 == null ? EditState.NONE : editState2;
            return editState;
        }
        finally {
            lock2.unlock();
        }
    }

    synchronized Lock getLock() {
        Lock lock2 = (Lock)this.getContext().getMap().getBlackboard().get(LOCK);
        if (lock2 == null) {
            lock2 = new ReentrantLock();
            this.getContext().getMap().getBlackboard().put(LOCK, (Object)lock2);
        }
        return lock2;
    }

    public void setCurrentState(EditState currentState) {
        if (currentState == null) {
            throw new NullPointerException("Edit state is null");
        }
        if (currentState == this.getCurrentState()) {
            return;
        }
        this.getContext().getMap().getBlackboard().put(EDITSTATE, (Object)currentState);
    }

    public List<EventBehaviour> getBehaviours() {
        return this.behaviour;
    }

    public List<EnablementBehaviour> getEnablementBehaviours() {
        return this.enablementBehaviours;
    }

    public EditBlackboard getEditBlackboard(ILayer layer) {
        return EditBlackboardUtil.getEditBlackboard(this.getContext(), layer);
    }

    public ILayer getEditLayer() {
        ILayer editLayer = this.getContext().getSelectedLayer();
        if (this.getContext().getEditManager().getEditLayer() != null && this.getContext().getEditManager().isEditLayerLocked()) {
            editLayer = this.getContext().getEditManager().getEditLayer();
        }
        return editLayer;
    }

    public Set<Activator> getActivators() {
        return this.activators;
    }

    public List<IDrawCommand> getDrawCommands() {
        return this.drawCommands;
    }

    public IToolContext getContext() {
        return this.context;
    }

    protected void setContext(IToolContext context2) {
        this.context = context2;
    }

    public void setCursor(final int cursor_id) {
        if (Display.getCurrent() != null) {
            if (this.tool != null) {
                this.tool.setCursorID(String.valueOf(cursor_id));
            }
        } else {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (EditToolHandler.this.tool != null) {
                        EditToolHandler.this.tool.setCursorID(String.valueOf(cursor_id));
                    }
                }
            });
        }
    }

    public void setCursor(final String cursorID) {
        if (Display.getCurrent() != null) {
            if (this.tool != null) {
                this.tool.setCursorID(cursorID);
            }
        } else {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (EditToolHandler.this.tool != null) {
                        EditToolHandler.this.tool.setCursorID(cursorID);
                    }
                }
            });
        }
    }

    public void setCursor(final Cursor cursor) {
        if (Display.getCurrent() != null) {
            this.getContext().getViewportPane().setCursor(cursor);
        } else {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EditToolHandler.this.getContext().getViewportPane().setCursor(cursor);
                }
            });
        }
    }

    public MouseTracker getMouseTracker() {
        return this.mouseTracker;
    }

    public List<Behaviour> getAcceptBehaviours() {
        return this.acceptBehaviours;
    }

    public List<Behaviour> getCancelBehaviours() {
        return this.cancelBehaviours;
    }

    public void lock(LockingBehaviour behaviour) {
        if (this.behaviourLock != null) {
            throw new IllegalArgumentException("Handler is locked and cannot be relocked");
        }
        this.behaviourLock = behaviour.getKey(this);
        if (this.behaviourLock == null) {
            throw new IllegalArgumentException("Null is not a legal key");
        }
    }

    public boolean isLocked() {
        return this.behaviourLock != null;
    }

    public void unlock(LockingBehaviour behaviour) {
        if (behaviour.getKey(this) != this.behaviourLock) {
            throw new IllegalArgumentException("Locking behaviour does not have the correct key");
        }
        this.behaviourLock = null;
    }

    public boolean isLockOwner(LockingBehaviour behaviour) {
        if (behaviour.getKey(this) == null) {
            throw new IllegalArgumentException("Null is not a legal key");
        }
        return behaviour.getKey(this) == this.behaviourLock;
    }

    public String toString() {
        return (Object)((Object)this.getCurrentState()) + ", " + this.getCurrentShape().getEditGeom() + ", " + this.mouseTracker;
    }

    public synchronized void repaint() {
        if (!this.processingEvent) {
            this.getContext().getViewportPane().repaint();
        } else {
            this.needRepaint = true;
        }
    }

    public void setTool(AbstractEditTool tool) {
        this.tool = tool;
    }

    public AbstractEditTool getTool() {
        return this.tool;
    }

    public EditBlackboard getCurrentEditBlackboard() {
        return this.getEditBlackboard(this.getEditLayer());
    }
}

