/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.refractions.udig.tools.edit.AdvancedFeaturesEventBehavior;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.MutualExclusiveEventBehavior;
import net.refractions.udig.tools.edit.OrderedCompositeEventBehavior;

public class EditToolConfigurationHelper {
    private List<EventBehaviour> behaviours;
    private Stack<Map> lists = new Stack();
    private List<EventBehaviour> current;
    private ListType currentType = ListType.NONE;
    private boolean done = false;
    private List<EventBehaviour> elseList;

    public EditToolConfigurationHelper(List<EventBehaviour> behaviours) {
        this.behaviours = behaviours;
        this.current = behaviours;
    }

    public void startMutualExclusiveList() {
        this.pushCurrentList();
        this.currentType = ListType.EXCLUSIVE;
        this.current = new ArrayList<EventBehaviour>();
    }

    public void stopMutualExclusiveList() {
        if (this.currentType != ListType.EXCLUSIVE) {
            throw new IllegalStateException("A mutual exclusive list is not the current type of list beingcreated: " + (Object)((Object)this.currentType));
        }
        MutualExclusiveEventBehavior mutualExclusiveBehavior = new MutualExclusiveEventBehavior(this.current);
        this.popLastList(mutualExclusiveBehavior);
    }

    public void startOrderedList(boolean processAsCommand) {
        this.pushCurrentList();
        this.currentType = processAsCommand ? ListType.ORDERED_COMMAND : ListType.ORDERED;
        this.current = new ArrayList<EventBehaviour>();
    }

    public void stopOrderedList() {
        if (this.currentType != ListType.ORDERED && this.currentType != ListType.ORDERED_COMMAND) {
            throw new IllegalStateException("A mutual exclusive list is not the current type of list beingcreated: " + (Object)((Object)this.currentType));
        }
        OrderedCompositeEventBehavior orderedCompositeBehaviour = new OrderedCompositeEventBehavior(this.current, this.currentType == ListType.ORDERED_COMMAND);
        this.popLastList(orderedCompositeBehaviour);
    }

    public void add(EventBehaviour behaviour) {
        this.current.add(behaviour);
    }

    public void done() {
        this.done = true;
        if (this.currentType != ListType.NONE) {
            throw new IllegalStateException("There are still " + this.lists.size() + "lists not finished, " + "the current list is a " + (Object)((Object)this.currentType) + " list");
        }
    }

    private void popLastList(EventBehaviour behavior) {
        if (this.lists.isEmpty()) {
            this.behaviours.add(behavior);
            this.current = this.behaviours;
            this.currentType = ListType.NONE;
        } else {
            Map map = this.lists.pop();
            map.list.add(behavior);
            this.current = map.list;
            this.currentType = map.type;
        }
    }

    private void pushCurrentList() {
        if (this.current != this.behaviours) {
            this.lists.push(new Map(this.currentType, this.current));
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void startAdvancedFeatures() {
        this.pushCurrentList();
        this.currentType = ListType.ADVANCED;
        this.current = new ArrayList<EventBehaviour>();
    }

    public void stopAdvancedFeatures() {
        if (this.currentType != ListType.ADVANCED) {
            throw new IllegalStateException("A advanced behaviours list is not the current type of list beingcreated: " + (Object)((Object)this.currentType));
        }
        AdvancedFeaturesEventBehavior behavior = new AdvancedFeaturesEventBehavior(this.current);
        if (this.elseList != null) {
            behavior.setElse(this.elseList);
            this.elseList = null;
        }
        this.popLastList(behavior);
    }

    public void startElseFeatures() {
        if (this.currentType != ListType.ADVANCED) {
            throw new IllegalStateException("Else Features can only be added to Advanced feature list.  Current list is: " + (Object)((Object)this.currentType));
        }
        this.pushCurrentList();
        this.currentType = ListType.ELSE;
        this.current = new ArrayList<EventBehaviour>();
        this.elseList = this.current;
    }

    public void stopElseFeatures() {
        if (this.currentType != ListType.ELSE) {
            throw new IllegalStateException("Else is not the current type of list beingadded. StartElseFeatures() must be called first.  Current type is: " + (Object)((Object)this.currentType));
        }
        Map map = this.lists.pop();
        this.currentType = map.type;
        this.current = map.list;
    }

    static enum ListType {
        EXCLUSIVE,
        ORDERED,
        NONE,
        ADVANCED,
        ELSE,
        ORDERED_COMMAND;

    }

    static class Map {
        final ListType type;
        final List<EventBehaviour> list;

        Map(ListType type, List<EventBehaviour> list) {
            this.type = type;
            this.list = list;
        }
    }
}

