/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.List;
import net.refractions.udig.project.AdaptableFeature;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.selection.provider.AbstractMapEditorSelectionProvider;
import net.refractions.udig.tools.edit.EditBlackboardUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditBlackboardEvent;
import net.refractions.udig.tools.edit.support.EditBlackboardListener;
import org.eclipse.jface.viewers.StructuredSelection;

public class EditSelectionProvider
extends AbstractMapEditorSelectionProvider {
    private EditBlackboardListener listener = new EditBlackboardListener(){

        @Override
        public void changed(EditBlackboardEvent e) {
            EditBlackboard old = EditBlackboardUtil.getEditBlackboard(EditSelectionProvider.this.context, EditSelectionProvider.this.map.getEditManager().getSelectedLayer());
            if (e.getEditBlackboard() != old) {
                e.getEditBlackboard().getListeners().remove(this);
                return;
            }
            if (e.getType() == EditBlackboardEvent.EventType.SELECTION) {
                EditSelectionProvider.this.selection();
            }
        }

        @Override
        public void batchChange(List<EditBlackboardEvent> e) {
            EditBlackboardEvent lastSelecion = null;
            for (EditBlackboardEvent event : e) {
                if (event.getType() != EditBlackboardEvent.EventType.SELECTION) continue;
                lastSelecion = event;
            }
            if (lastSelecion != null) {
                this.changed(lastSelecion);
            }
        }
    };
    private IMap map;
    private final IEditManagerListener editManagerListener = new IEditManagerListener(){

        public void changed(EditManagerEvent event) {
            if (event.getSource() != EditSelectionProvider.this.map.getEditManager()) {
                event.getSource().removeListener((IEditManagerListener)this);
                return;
            }
            switch (event.getType()) {
                case 0: {
                    AdaptableFeature selectedFeature = (AdaptableFeature)event.getNewValue();
                    if (selectedFeature == null) {
                        EditSelectionProvider.this.selection = new StructuredSelection();
                    } else {
                        EditSelectionProvider.this.selection = new StructuredSelection((Object)selectedFeature);
                    }
                    EditSelectionProvider.this.notifyListeners();
                    break;
                }
                case 5: {
                    if (event.getNewValue() == event.getOldValue()) {
                        return;
                    }
                    EditBlackboard old = EditBlackboardUtil.getEditBlackboard(EditSelectionProvider.this.context, (ILayer)event.getOldValue());
                    old.getListeners().remove(EditSelectionProvider.this.listener);
                    EditSelectionProvider.this.selection();
                    break;
                }
            }
        }
    };
    private IToolContext context;

    public void setActiveMap(IMap map, MapPart editor) {
        this.map = map;
        this.context = ApplicationGIS.createContext((IMap)map);
        this.selection();
        map.getEditManager().addListener(this.editManagerListener);
        EditBlackboard editBlackboard = EditBlackboardUtil.getEditBlackboard(this.context, map.getEditManager().getSelectedLayer());
        editBlackboard.getListeners().add(this.listener);
    }

    private void selection() {
        if (!this.selectVertices()) {
            this.selectEditFeature();
        }
    }

    private boolean selectVertices() {
        EditBlackboard editBlackboard = EditBlackboardUtil.getEditBlackboard(this.context, this.map.getEditManager().getSelectedLayer());
        if (editBlackboard == null || editBlackboard.getSelection().isEmpty()) {
            return false;
        }
        this.selection = new StructuredSelection(editBlackboard.getSelection().toArray());
        this.notifyListeners();
        return true;
    }

    private void selectEditFeature() {
        AdaptableFeature selectedFeature = (AdaptableFeature)this.map.getEditManager().getEditFeature();
        this.selection = selectedFeature == null ? new StructuredSelection() : new StructuredSelection((Object)selectedFeature);
        this.notifyListeners();
    }
}

