/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import org.opengis.feature.simple.SimpleFeature;

public class EditManagerListenerActivator
implements Activator,
IEditManagerListener {
    private EditToolHandler handler;

    @Override
    public void activate(EditToolHandler handler) {
        this.handler = handler;
        handler.getContext().getEditManager().addListener((IEditManagerListener)this);
    }

    @Override
    public void deactivate(EditToolHandler handler) {
        handler.getContext().getEditManager().removeListener((IEditManagerListener)this);
    }

    @Override
    public void handleActivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("Activate Error", error);
    }

    @Override
    public void handleDeactivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("Deactivate Error", error);
    }

    public void changed(EditManagerEvent event) {
        int type = event.getType();
        if (type == 0) {
            EditGeom currentGeom = this.handler.getCurrentGeom();
            SimpleFeature newValue = (SimpleFeature)event.getNewValue();
            if (currentGeom == null && newValue != null) {
                this.setCurrentGeom(newValue);
            } else if (currentGeom != null && newValue == null) {
                this.handler.setCurrentShape(null);
            } else {
                String fid = this.handler.getCurrentGeom().getFeatureIDRef().get();
                if (!fid.equals(newValue.getID())) {
                    this.setCurrentGeom(newValue);
                }
            }
        }
    }

    private void setCurrentGeom(SimpleFeature newValue) {
        EditBlackboard bb = this.handler.getEditBlackboard(this.handler.getContext().getSelectedLayer());
        Map<Geometry, EditGeom> editGeoms = bb.setGeometries((Geometry)newValue.getDefaultGeometry(), newValue.getID());
        if (editGeoms.isEmpty()) {
            return;
        }
        EditGeom firstShape = editGeoms.values().iterator().next();
        this.handler.setCurrentShape(firstShape.getShell());
    }
}

