/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.PostDeterminedEffectCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class BehaviourCommand
extends AbstractCommand
implements PostDeterminedEffectCommand {
    private List<Behaviour> behaviours;
    private List<UndoableMapCommand> commandsRan = new LinkedList<UndoableMapCommand>();
    private EditToolHandler handler;
    String name = Messages.EventBehaviourCommand_name;

    public BehaviourCommand(List<Behaviour> behaviours, EditToolHandler handler) {
        this.behaviours = behaviours;
        this.handler = handler;
    }

    public boolean execute(IProgressMonitor monitor) throws Exception {
        if (this.commandsRan.isEmpty()) {
            monitor.beginTask(this.getName(), this.commandsRan.size() * 12);
            monitor.worked(2);
            for (Behaviour behaviour : this.behaviours) {
                monitor.beginTask(this.getName(), this.behaviours.size() * 12);
                monitor.worked(2);
                if (!behaviour.isValid(this.handler)) continue;
                UndoableMapCommand c = null;
                try {
                    c = behaviour.getCommand(this.handler);
                    if (c == null) continue;
                    c.setMap((IMap)this.getMap());
                    SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 10);
                    if (c instanceof PostDeterminedEffectCommand) {
                        PostDeterminedEffectCommand command = (PostDeterminedEffectCommand)c;
                        if (command.execute((IProgressMonitor)submonitor)) {
                            this.commandsRan.add((UndoableMapCommand)command);
                        }
                    } else {
                        c.run((IProgressMonitor)submonitor);
                        this.commandsRan.add(c);
                    }
                    submonitor.done();
                }
                catch (Exception e) {
                    EditPlugin.trace(String.valueOf(e.getClass().getName()) + " executing " + c + ":" + e.getMessage(), e);
                    behaviour.handleError(this.handler, e, c);
                }
            }
        } else {
            monitor.beginTask(this.getName(), this.commandsRan.size() * 12);
            monitor.worked(2);
            for (UndoableMapCommand command : this.commandsRan) {
                command.setMap((IMap)this.getMap());
                SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 10);
                if (command instanceof PostDeterminedEffectCommand) {
                    ((PostDeterminedEffectCommand)command).execute((IProgressMonitor)submonitor);
                } else {
                    command.run((IProgressMonitor)submonitor);
                }
                submonitor.done();
            }
        }
        return !this.commandsRan.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(this.getName(), this.commandsRan.size() * 12);
        monitor.worked(2);
        for (UndoableMapCommand command : this.commandsRan) {
            command.setMap((IMap)this.getMap());
            SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 10);
            command.rollback((IProgressMonitor)submonitor);
            submonitor.done();
        }
    }

    public void run(IProgressMonitor monitor) throws Exception {
        throw new UnsupportedOperationException("PostDeterminedEffectCommands do not use the run method");
    }
}

