/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.List;
import java.util.Set;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.tool.display.CursorProxy;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelEvent;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.project.ui.tool.SimpleTool;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolConfigurationHelper;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.activator.EnableAcceptEditCommandHandlerActivator;
import net.refractions.udig.tools.edit.support.EditUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractEditTool
extends SimpleTool {
    protected EditToolHandler handler;

    public AbstractEditTool() {
        super(7);
    }

    public void init(IConfigurationElement element) {
        Cursor editCursor = null;
        IToolManager toolManager = ApplicationGIS.getToolManager();
        String cursorId = element.getAttribute("toolCursorId");
        if (cursorId != null) {
            editCursor = toolManager.findToolCursor(cursorId);
        }
        if (editCursor == null) {
            IConfigurationElement[] cursorElement = element.getChildren("cursor");
            editCursor = new CursorProxy(cursorElement[0]).getCursor();
        }
        if (editCursor == null) {
            editCursor = Display.getDefault().getSystemCursor(0);
        }
        Cursor selectionCursor = toolManager.findToolCursor("boxSelectionCursor");
        this.handler = new EditToolHandler(selectionCursor, editCursor);
        this.initRequiredActivators();
        EditToolConfigurationHelper editToolConfigurationHelper = new EditToolConfigurationHelper(this.getHandler().getBehaviours());
        this.initEventBehaviours(editToolConfigurationHelper);
        this.initEnablementBehaviours(this.handler.getEnablementBehaviours());
        this.initRequiredAcceptBehaviours();
        this.initCancelBehaviours(this.handler.getCancelBehaviours());
        this.handler.setTool(this);
        if (!editToolConfigurationHelper.isDone()) {
            throw new IllegalStateException("configurator's done method was not called.");
        }
    }

    private void initRequiredActivators() {
        this.initActivators(this.handler.getActivators());
        this.handler.getActivators().add(new EnableAcceptEditCommandHandlerActivator());
    }

    private void initRequiredAcceptBehaviours() {
        this.initAcceptBehaviours(this.handler.getAcceptBehaviours());
        this.handler.getAcceptBehaviours().add(new Behaviour(){

            @Override
            public UndoableMapCommand getCommand(EditToolHandler handler) {
                EditUtils.instance.clearLayerStateShapeCache(handler.getContext().getMapLayers());
                return null;
            }

            @Override
            public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
                EditPlugin.log("", error);
            }

            @Override
            public boolean isValid(EditToolHandler handler) {
                return true;
            }
        });
    }

    protected abstract void initActivators(Set<Activator> var1);

    protected abstract void initAcceptBehaviours(List<Behaviour> var1);

    protected abstract void initCancelBehaviours(List<Behaviour> var1);

    protected abstract void initEventBehaviours(EditToolConfigurationHelper var1);

    protected abstract void initEnablementBehaviours(List<EnablementBehaviour> var1);

    public void testinitActivators(Set<Activator> activators) {
        this.initActivators(activators);
    }

    public void testinitAcceptBehaviours(List<Behaviour> acceptBehaviours) {
        this.initAcceptBehaviours(acceptBehaviours);
    }

    public void testinitCancelBehaviours(List<Behaviour> cancelBehaviours) {
        this.initCancelBehaviours(cancelBehaviours);
    }

    public void testinitEventBehaviours(EditToolConfigurationHelper helper) {
        this.initEventBehaviours(helper);
    }

    public void setContext(IToolContext context) {
        if (this.getContext() != null && this.getContext().getViewportPane() != null) {
            this.getContext().getViewportPane().repaint();
        }
        super.setContext(context);
        this.handler.setContext(context);
        if (this.isActive()) {
            this.handler.basicDisablement();
            this.handler.basicEnablement();
        }
        this.handler.repaint();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.handler.setActive(active);
    }

    protected void onMouseDoubleClicked(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.DOUBLE_CLICK);
    }

    protected void onMouseDragged(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.DRAGGED);
    }

    protected void onMouseEntered(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.ENTERED);
    }

    protected void onMouseExited(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.EXITED);
    }

    protected void onMouseMoved(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.MOVED);
    }

    protected void onMousePressed(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.PRESSED);
    }

    protected void onMouseReleased(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.RELEASED);
    }

    protected void onMouseWheelMoved(MapMouseWheelEvent e) {
        this.handler.handleEvent((MapMouseEvent)e, EventType.WHEEL);
    }

    protected void onMouseHovered(MapMouseEvent e) {
        this.handler.handleEvent(e, EventType.HOVERED);
    }

    public EditToolHandler getHandler() {
        return this.handler;
    }

    public void setHandler(EditToolHandler handler) {
        this.handler = handler;
    }
}

