/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.edit;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IRepository;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class DifferenceOp
implements IOp {
    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        final ILayer[] layers = (ILayer[])target;
        final int[] value = new int[1];
        final ILayer[] from = new ILayer[1];
        final ILayer[] diff = new ILayer[1];
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LayerSelection selection = new LayerSelection(display.getActiveShell(), layers);
                value[0] = selection.open();
                from[0] = selection.fromLayer;
                diff[0] = selection.diffLayer;
            }
        });
        if (value[0] == 1) {
            return;
        }
        ILayer fromLayer = from[0];
        ILayer diffLayer = diff[0];
        if (!fromLayer.hasResource(FeatureSource.class)) {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.differenceOp_inputError1, (String)(String.valueOf(fromLayer.getName()) + Messages.differenceOp_inputError2));
            return;
        }
        if (!diffLayer.hasResource(FeatureSource.class)) {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.differenceOp_inputError1, (String)(String.valueOf(diffLayer.getName()) + Messages.differenceOp_inputError2));
            return;
        }
        ShapefileDataStoreFactory dsfac = new ShapefileDataStoreFactory();
        File tmp = File.createTempFile(String.valueOf(layers[0].getName()) + "_" + layers[1].getName() + "_diff", ".shp");
        FileDataStore ds = dsfac.createDataStore(tmp.toURL());
        final SimpleFeatureType newSchema = FeatureTypes.newFeatureType((AttributeDescriptor[])fromLayer.getSchema().getAttributeDescriptors().toArray(new AttributeDescriptor[0]), (String)"diff");
        ds.createSchema((FeatureType)newSchema);
        FeatureSource fromSource = (FeatureSource)fromLayer.getResource(FeatureSource.class, monitor);
        FeatureSource diffSource = (FeatureSource)diffLayer.getResource(FeatureSource.class, monitor);
        if (this.isGeometryCollection(((SimpleFeatureType)fromSource.getSchema()).getGeometryDescriptor())) {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.differenceOp_inputError, (String)(String.valueOf(fromLayer.getName()) + Messages.differenceOp_multiGeoms));
            return;
        }
        if (this.isGeometryCollection(((SimpleFeatureType)diffSource.getSchema()).getGeometryDescriptor())) {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.differenceOp_inputError, (String)(String.valueOf(fromLayer.getName()) + Messages.differenceOp_multiGeoms));
            return;
        }
        SimpleFeatureCollection diffFeatures = FeatureCollections.newCollection();
        diffFeatures.addAll(diffSource.getFeatures());
        FeatureStore destStore = (FeatureStore)ds.getFeatureSource("diff");
        destStore.addFeatures((FeatureCollection)DataUtilities.collection((FeatureReader)new FeatureReader<SimpleFeatureType, SimpleFeature>(fromSource, (FeatureCollection)diffFeatures){
            FeatureCollection<SimpleFeatureType, SimpleFeature> coll;
            FeatureIterator<SimpleFeature> iter;
            FeatureIterator<SimpleFeature> peek;
            boolean hasNextCalled;
            private final /* synthetic */ FeatureCollection val$diffFeatures;
            {
                this.val$diffFeatures = featureCollection;
                this.coll = featureSource.getFeatures();
                this.iter = this.coll.features();
                this.peek = this.coll.features();
                this.hasNextCalled = false;
            }

            public SimpleFeatureType getFeatureType() {
                return newSchema;
            }

            private Geometry diff(SimpleFeature f) {
                Geometry geom = (Geometry)f.getDefaultGeometry();
                FeatureIterator i = this.val$diffFeatures.features();
                try {
                    while (i.hasNext()) {
                        SimpleFeature diff = (SimpleFeature)i.next();
                        Geometry g = geom.difference((Geometry)diff.getDefaultGeometry());
                        if (g.isEmpty()) {
                            return null;
                        }
                        geom = g;
                    }
                }
                finally {
                    i.close();
                }
                return geom;
            }

            public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                SimpleFeature source = (SimpleFeature)this.iter.next();
                Geometry geom = this.diff(source);
                if (geom == null || !this.hasNextCalled) {
                    throw new NoSuchElementException("Use hasNext().");
                }
                if (geom instanceof LineString) {
                    geom = geom.getFactory().createMultiLineString(new LineString[]{(LineString)geom});
                }
                if (geom instanceof Polygon) {
                    geom = geom.getFactory().createMultiPolygon(new Polygon[]{(Polygon)geom});
                }
                source.setDefaultGeometry((Object)geom);
                this.hasNextCalled = false;
                return source;
            }

            public boolean hasNext() throws IOException {
                if (this.hasNextCalled) {
                    return this.iter.hasNext();
                }
                try {
                    Geometry g = null;
                    while (g == null) {
                        if (!this.peek.hasNext()) {
                            return false;
                        }
                        SimpleFeature f = (SimpleFeature)this.peek.next();
                        g = this.diff(f);
                        if (g == null) {
                            this.iter.next();
                            continue;
                        }
                        return true;
                    }
                }
                finally {
                    this.hasNextCalled = true;
                }
                return false;
            }

            public void close() throws IOException {
                this.iter.close();
                this.peek.close();
            }
        }));
        URL url = tmp.toURI().toURL();
        IRepository local = CatalogPlugin.getDefault().getLocal();
        IService service = local.acquire(url, null);
        List resources = service.resources(null);
        IGeoResource resource = (IGeoResource)resources.get(0);
        Map map = (Map)layers[0].getMap();
        LayerFactory factory = map.getLayerFactory();
        Layer outLayer = factory.createLayer(resource);
        map.getLayersInternal().add(outLayer);
    }

    protected boolean isGeometryCollection(GeometryDescriptor g) {
        return g.getClass().getName().equals("com.vividsolutions.jts.geom.GeometryCollection");
    }

    static class LayerSelection
    extends Dialog {
        private ILayer[] layers;
        Combo fromCombo;
        Combo diffCombo;
        ILayer fromLayer;
        ILayer diffLayer;

        protected LayerSelection(Shell parentShell, ILayer[] layers) {
            super(parentShell);
            this.layers = layers;
            this.fromLayer = layers[0];
            this.diffLayer = layers[1];
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = (Composite)super.createDialogArea(parent);
            Composite c = new Composite(comp, 0);
            c.setLayout((Layout)new GridLayout(2, true));
            String[] names = new String[]{this.layers[0].getName(), this.layers[1].getName()};
            Label layer2 = new Label(c, 0);
            layer2.setLayoutData((Object)new GridData(768));
            layer2.setText("Subtract: ");
            this.diffCombo = new Combo(c, -1);
            this.diffCombo.setLayoutData((Object)new GridData(1808));
            this.diffCombo.setItems(names);
            this.diffCombo.select(1);
            Label layer1 = new Label(c, 0);
            layer1.setLayoutData((Object)new GridData(768));
            layer1.setText("From: ");
            this.fromCombo = new Combo(c, -1);
            this.fromCombo.setLayoutData((Object)new GridData(1808));
            this.fromCombo.setItems(names);
            this.fromCombo.select(0);
            this.diffCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    LayerSelection.this.diffLayer = LayerSelection.this.layers[LayerSelection.this.diffCombo.getSelectionIndex()];
                }
            });
            this.fromCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    LayerSelection.this.fromLayer = LayerSelection.this.layers[LayerSelection.this.fromCombo.getSelectionIndex()];
                }
            });
            return c;
        }
    }
}

