/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.ui;

import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.process.MarkModelFactory;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class MarkStorage {
    private Properties propertiesMarks = new Properties();
    private int index;
    private int highestIndex = -1;
    private String loadedCrsName = "";

    MarkStorage() {
    }

    public boolean canLoadMarks(String path, CoordinateReferenceSystem crs) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(path);
            this.propertiesMarks.load(reader);
            this.loadedCrsName = this.propertiesMarks.getProperty("0");
            String actualCrs = crs.getName().getCode();
            if (this.loadedCrsName.equals(actualCrs)) {
                return true;
            }
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
        return false;
    }

    public String getLoadedCrsName() {
        assert (!"".equals(this.loadedCrsName));
        return this.loadedCrsName;
    }

    public Map<String, MarkModel> loadMarks(String path) throws IOException {
        Reader reader = null;
        try {
            HashMap<Integer, MarkModel> unsortedMarkMap = new HashMap<Integer, MarkModel>();
            reader = new FileReader(path);
            this.propertiesMarks.load(reader);
            Set<Map.Entry<Object, Object>> entrySet = this.propertiesMarks.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                String key = (String)entry.getKey();
                if (key.equals("0")) continue;
                String markValues = (String)entry.getValue();
                MarkModel mark = this.parseMarkData(markValues);
                unsortedMarkMap.put(this.index, mark);
            }
            Map<String, MarkModel> map = this.sortMap(unsortedMarkMap);
            return map;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Map<String, MarkModel> sortMap(Map<Integer, MarkModel> unsortedMarkMap) {
        LinkedHashMap<String, MarkModel> sortedMap = new LinkedHashMap<String, MarkModel>();
        int i = 1;
        while (i <= this.highestIndex) {
            MarkModel mark = unsortedMarkMap.get(i);
            String key = mark.getID();
            sortedMap.put(key, mark);
            ++i;
        }
        return sortedMap;
    }

    private MarkModel parseMarkData(String markValues) {
        MarkModel newMark = null;
        StringTokenizer tokenizer = new StringTokenizer(markValues, ";");
        String id = tokenizer.nextToken();
        try {
            Integer xImage = Integer.parseInt(tokenizer.nextToken());
            Integer yImage = Integer.parseInt(tokenizer.nextToken());
            Double xCoord = Double.parseDouble(tokenizer.nextToken());
            Double yCoord = Double.parseDouble(tokenizer.nextToken());
            newMark = MarkModelFactory.getInstance().create(id, xImage, yImage, xCoord, yCoord);
            this.index = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (this.index > this.highestIndex) {
            this.highestIndex = this.index;
        }
        return newMark;
    }

    public void saveMarks(Map<String, MarkModel> marks, CoordinateReferenceSystem crs, String fileName) throws IOException {
        Writer out = null;
        try {
            this.propertiesMarks.setProperty("0", crs.getName().getCode());
            Set<Map.Entry<String, MarkModel>> entrySet = marks.entrySet();
            Iterator<Map.Entry<String, MarkModel>> iter = entrySet.iterator();
            int order = 1;
            while (iter.hasNext()) {
                Map.Entry<String, MarkModel> entry = iter.next();
                String key = entry.getKey();
                MarkModel mark = entry.getValue();
                this.propertiesMarks.setProperty(key, String.valueOf(mark.toString()) + ";" + order);
                ++order;
            }
            out = new FileWriter(fileName);
            this.propertiesMarks.store(out, "georeferencing marks");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

