/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.ui;

import eu.udig.image.georeferencing.internal.i18n.Messages;
import eu.udig.image.georeferencing.internal.preferences.Preferences;
import eu.udig.image.georeferencing.internal.process.MarkModelFactory;
import eu.udig.image.georeferencing.internal.ui.GeoReferencingCommand;
import eu.udig.image.georeferencing.internal.ui.GeoreferencingCommandEventChange;
import eu.udig.image.georeferencing.internal.ui.MainComposite;
import eu.udig.image.georeferencing.internal.ui.message.InfoMessage;
import eu.udig.image.georeferencing.ui.MarkStorage;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.opengis.feature.simple.SimpleFeature;

public class GeoreferencingView
extends ViewPart
implements IUDIGView,
Observer {
    public static final String id = "eu.udig.image.georeferencing.ui.GeoreferencingView";
    private static final String GCP_FILE_EXT = "*.gcp";
    private static final String LOAD_IMAGE_BUTTON = "images/load.png";
    private static final String RUN_IMAGE_BUTTON = "images/run.gif";
    private static final String SAVE_IMAGE_BUTTON = "images/save.png";
    private GeoReferencingCommand cmd = null;
    private MainComposite mainComposite = null;
    private IToolContext toolContext = null;
    private runButtonAction runButton = null;
    private loadButtonAction loadButton = null;
    private saveButtonAction saveButton = null;
    private IAction runAction;
    private IAction loadAction;
    private IAction saveAction;
    private Thread displayThread = null;
    private MarkStorage marksStore = new MarkStorage();

    public GeoreferencingView() {
        this.displayThread = Display.getCurrent().getThread();
    }

    public void createPartControl(Composite parent) {
        MarkModelFactory.resetIdSecuence();
        this.cmd = new GeoReferencingCommand();
        MainComposite composite = new MainComposite(this.cmd, parent, 524288);
        composite.setLayout((Layout)new FillLayout());
        composite.pack();
        this.createActions();
        this.createToolbar(composite);
        this.mainComposite = composite;
        this.cmd.addObserver(this);
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void dispose() {
        this.mainComposite.close();
        super.dispose();
    }

    private void createToolbar(Composite composite) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.runButton);
        toolbar.add((IAction)this.loadButton);
        toolbar.add((IAction)this.saveButton);
        this.runButton.setEnabled(false);
        this.loadButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add(this.runAction);
        viewMenu.add(this.loadAction);
        viewMenu.add(this.saveAction);
    }

    private void createActions() {
        this.runButton = new runButtonAction();
        this.runAction = new Action(){

            public void run() {
                GeoreferencingView.this.executeGeoReferencingCommand();
            }
        };
        this.runAction.setText(Messages.GeoreferencingView_runActionText);
        this.runAction.setToolTipText(Messages.GeoreferencingView_runActionTooltip);
        String imgFile = RUN_IMAGE_BUTTON;
        this.runAction.setImageDescriptor(ImageDescriptor.createFromFile(GeoreferencingView.class, (String)imgFile));
        this.runAction.setEnabled(false);
        this.loadButton = new loadButtonAction();
        this.loadAction = new Action(){

            public void run() {
                GeoreferencingView.this.loadMarks();
            }
        };
        this.loadAction.setText(Messages.GeoreferencingView_loadActionText);
        this.loadAction.setToolTipText(Messages.GeoreferencingView_loadActionTooltip);
        imgFile = LOAD_IMAGE_BUTTON;
        this.loadAction.setImageDescriptor(ImageDescriptor.createFromFile(GeoreferencingView.class, (String)imgFile));
        this.loadAction.setEnabled(false);
        this.saveButton = new saveButtonAction();
        this.saveAction = new Action(){

            public void run() {
                GeoreferencingView.this.saveMarks();
            }
        };
        this.saveAction.setText(Messages.GeoreferencingView_saveActionText);
        this.saveAction.setToolTipText(Messages.GeoreferencingView_saveActionTooltip);
        imgFile = SAVE_IMAGE_BUTTON;
        this.saveAction.setImageDescriptor(ImageDescriptor.createFromFile(GeoreferencingView.class, (String)imgFile));
        this.saveAction.setEnabled(false);
    }

    protected void executeGeoReferencingCommand() {
        try {
            try {
                this.showEnabled(false);
                this.cmd.execute();
            }
            catch (Exception exception) {
                this.mainComposite.displayMessage(new InfoMessage("Fail!. The georeferencing process didn't genereate the raster image", InfoMessage.Type.FAIL));
                this.showEnabled(true);
            }
        }
        finally {
            this.showEnabled(true);
        }
    }

    private void saveMarks() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setFilterExtensions(new String[]{GCP_FILE_EXT});
        fd.setText(Messages.GeoreferencingView_saveMarksFile);
        fd.setFilterPath(Preferences.getSaveLoadPath());
        String marksFileName = fd.open();
        if (marksFileName != null && !"".equals(marksFileName)) {
            try {
                this.marksStore.saveMarks(this.cmd.getMarks(), this.cmd.getCRS(), marksFileName);
                File file = new File(marksFileName);
                Preferences.setSaveLoadPath(file.getParent());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadMarks() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setFilterExtensions(new String[]{GCP_FILE_EXT});
        fd.setText(Messages.GeoreferencingView_openMarksFile);
        fd.setFilterPath(Preferences.getSaveLoadPath());
        String marksFile = fd.open();
        if (marksFile != null && !"".equals(marksFile)) {
            try {
                if (this.marksStore.canLoadMarks(marksFile, this.cmd.getCRS())) {
                    this.mainComposite.deleteAllPoints();
                    this.mainComposite.createMarks(this.marksStore.loadMarks(marksFile));
                } else {
                    InfoMessage message = new InfoMessage(String.valueOf(Messages.GeoreferencingView_errorLoadingMarks) + this.marksStore.getLoadedCrsName(), InfoMessage.Type.WARNING);
                    this.mainComposite.setMessage(message);
                }
                File file = new File(marksFile);
                Preferences.setSaveLoadPath(file.getParent());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void showEnabled(boolean enabled) {
        this.mainComposite.setEnabled(enabled);
        if (enabled) {
            this.mainComposite.setCursor(null);
        } else {
            this.mainComposite.setCursor(Display.getCurrent().getSystemCursor(1));
        }
    }

    public void setContext(final IToolContext newContext) {
        assert (this.displayThread != null);
        Display display = Display.findDisplay((Thread)this.displayThread);
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                GeoreferencingView.this.toolContext = newContext;
                GeoreferencingView.this.mainComposite.setContext(GeoreferencingView.this.toolContext);
            }
        });
    }

    public IToolContext getContext() {
        return this.toolContext;
    }

    private void enableRunButton(boolean enable) {
        if (this.runButton != null) {
            this.runButton.setEnabled(enable);
        }
        if (this.runAction != null) {
            this.runAction.setEnabled(enable);
        }
    }

    private void enableLoadButton(boolean enable) {
        if (this.loadButton != null) {
            this.loadButton.setEnabled(enable);
        }
        if (this.loadAction != null) {
            this.loadAction.setEnabled(enable);
        }
    }

    private void enableSaveButton(boolean enable) {
        if (this.saveButton != null) {
            this.saveButton.setEnabled(enable);
        }
        if (this.saveAction != null) {
            this.saveAction.setEnabled(enable);
        }
    }

    public void editFeatureChanged(SimpleFeature feature) {
    }

    @Override
    public void update(Observable obs, Object arg) {
        assert (obs instanceof GeoReferencingCommand);
        GeoReferencingCommand cmd = (GeoReferencingCommand)obs;
        this.enableRunButton(cmd.canExectue());
        this.enableSaveButton(cmd.canSave());
        if (!(arg instanceof GeoreferencingCommandEventChange)) {
            return;
        }
        GeoreferencingCommandEventChange cmdEvent = (GeoreferencingCommandEventChange)arg;
        switch (cmdEvent.getEvent()) {
            case MARK_ADDED: {
                this.enableSaveButton(true);
                break;
            }
            case ALL_MARKS_DELETED: {
                this.enableSaveButton(false);
                break;
            }
            case IMAGE_LOADED: {
                this.enableLoadButton(true);
                break;
            }
            case MAP_CHANGE: {
                this.enableRunButton(false);
                this.enableSaveButton(false);
                this.enableLoadButton(false);
                break;
            }
            case MAP_CHANGE_TO_ORIGINAL: {
                this.enableRunButton(cmd.canExectue());
                this.enableSaveButton(cmd.canSave());
                this.enableLoadButton(cmd.canLoad());
                break;
            }
        }
    }

    private class loadButtonAction
    extends Action {
        public loadButtonAction() {
            this.setToolTipText(Messages.GeoreferencingView_loadButtonText);
            String imgFile = GeoreferencingView.LOAD_IMAGE_BUTTON;
            this.setImageDescriptor(ImageDescriptor.createFromFile(GeoreferencingView.class, (String)imgFile));
        }

        public void run() {
            GeoreferencingView.this.loadMarks();
        }
    }

    private class runButtonAction
    extends Action {
        public runButtonAction() {
            this.setToolTipText(Messages.GeoreferencingView_runButtonText);
            String imgFile = GeoreferencingView.RUN_IMAGE_BUTTON;
            this.setImageDescriptor(ImageDescriptor.createFromFile(GeoreferencingView.class, (String)imgFile));
        }

        public void run() {
            GeoreferencingView.this.executeGeoReferencingCommand();
        }
    }

    private class saveButtonAction
    extends Action {
        public saveButtonAction() {
            this.setToolTipText(Messages.GeoreferencingView_saveButtonText);
            String imgFile = GeoreferencingView.SAVE_IMAGE_BUTTON;
            this.setImageDescriptor(ImageDescriptor.createFromFile(GeoreferencingView.class, (String)imgFile));
        }

        public void run() {
            GeoreferencingView.this.saveMarks();
        }
    }
}

