/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel.tools;

import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImageComposite;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.AbstractImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ImageInputEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;

public class PanImageTool
extends AbstractImageTool {
    private int xScrollStart = -1;
    private int yScrollStart = -1;

    public PanImageTool(Cursor cursor, ImageComposite imgComposite) {
        super(cursor, imgComposite);
    }

    @Override
    protected boolean canHandle(ImageInputEvent ev) {
        return InputEvent.MOUSE_DRAG.equals((Object)ev.event) || InputEvent.MOUSE_UP.equals((Object)ev.event) || InputEvent.MOUSE_DOWN.equals((Object)ev.event);
    }

    @Override
    protected boolean executeBehaviour(ImageInputEvent ev) {
        this.imagePan(ev.x, ev.y, ev.event);
        return false;
    }

    private void imagePan(int x, int y, InputEvent eventType) {
        switch (eventType) {
            case MOUSE_DOWN: {
                this.xScrollStart = x + Math.abs(this.imgComposite.getHScrollValue());
                this.yScrollStart = y + Math.abs(this.imgComposite.getVScrollValue());
                break;
            }
            case MOUSE_DRAG: {
                if (this.xScrollStart == -1 || this.yScrollStart == -1) break;
                this.doPan(x, y);
                break;
            }
            case MOUSE_UP: {
                this.xScrollStart = -1;
                this.yScrollStart = -1;
                break;
            }
        }
    }

    private void doPan(int x, int y) {
        int yScrollSelection;
        Rectangle bounds = this.imgComposite.getCanvasClientArea();
        int xScrollSelection = x - this.xScrollStart;
        if (xScrollSelection != 0 && xScrollSelection + this.imgComposite.getMaxX() < bounds.width) {
            xScrollSelection = bounds.width - this.imgComposite.getMaxX();
        }
        if (xScrollSelection > 0) {
            xScrollSelection = 0;
        }
        if ((yScrollSelection = y - this.yScrollStart) != 0 && yScrollSelection + this.imgComposite.getMaxY() < bounds.height) {
            yScrollSelection = bounds.height - this.imgComposite.getMaxY();
        }
        if (yScrollSelection > 0) {
            yScrollSelection = 0;
        }
        this.imgComposite.updateScrollValues(xScrollSelection, yScrollSelection);
        this.imgComposite.broadcastPanEvent();
        this.imgComposite.canvasRedraw();
    }
}

