/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel.tools;

import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImageComposite;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImagePanelUtil;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenter;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.AbstractImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ImageInputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.MarkImagePreview;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;

public class MoveMarkImageTool
extends AbstractImageTool {
    private MarkImagePreview markPreview = null;

    public MoveMarkImageTool(Cursor cursor, ImageComposite imgComposite) {
        super(cursor, imgComposite);
    }

    @Override
    protected boolean canHandle(ImageInputEvent ev) {
        return InputEvent.MOUSE_DRAG.equals((Object)ev.event) || InputEvent.MOUSE_UP.equals((Object)ev.event) || InputEvent.MOUSE_DOWN.equals((Object)ev.event);
    }

    @Override
    protected boolean executeBehaviour(ImageInputEvent ev) {
        MarkImagePresenter presenter = this.imgComposite.getMarkUnderCursor(ev.x, ev.y);
        this.dragAndDrop(ev.x, ev.y, ev.event, presenter);
        return false;
    }

    private void dragAndDrop(int x, int y, InputEvent inputEvent, MarkImagePresenter presenter) {
        switch (inputEvent) {
            case MOUSE_DOWN: {
                if (presenter == null || this.markPreview != null) break;
                this.markPreview = new MarkImagePreview(presenter, this.imgComposite.getCanvas());
                break;
            }
            case MOUSE_DRAG: {
                if (this.markPreview != null) {
                    this.markPreview.eventHandler(inputEvent, x, y);
                    break;
                }
                this.showFeedback(x, y, inputEvent);
                break;
            }
            case MOUSE_UP: {
                int vScroll;
                if (this.markPreview == null) break;
                int hScroll = Math.abs(this.imgComposite.getHScrollValue());
                Point point = ImagePanelUtil.createMarkPosition(hScroll, vScroll = Math.abs(this.imgComposite.getVScrollValue()), x, y, this.imgComposite.getScale());
                if (this.validateInside(point)) {
                    this.markPreview.getMarkModel().updateImagePosition(point);
                }
                this.markPreview.delete();
                this.markPreview = null;
                this.imgComposite.canvasRedraw();
                break;
            }
        }
    }
}

