/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel.tools;

import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.AbstractMarkPresenter;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenter;
import java.awt.Color;
import java.util.Observable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

final class MarkImagePreview
extends AbstractMarkPresenter
implements MarkImagePresenter {
    private MarkImagePresenter parent = null;
    private Canvas canvas;
    private GC gc;
    private int xRelativeToCanvas;
    private int yRelativeToCanvas;
    private int x;
    private int y;

    public MarkImagePreview(MarkImagePresenter parent, Canvas canvas) {
        assert (parent != null);
        this.parent = parent;
        this.canvas = canvas;
        this.createContent(canvas);
    }

    private void createContent(Canvas parent) {
        parent.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                MarkImagePreview.this.gc = event.gc;
                MarkImagePreview.this.draw();
            }
        });
    }

    @Override
    public void update(Observable arg0, Object arg1) {
    }

    @Override
    public boolean eventHandler(InputEvent event, int x, int y) {
        switch (event) {
            case MOUSE_DRAG: {
                this.x = x;
                this.y = y;
                this.canvas.redraw();
                break;
            }
        }
        return false;
    }

    @Override
    public void draw() {
        assert (this.gc != null);
        assert (!this.gc.isDisposed());
        if (this.hide) {
            return;
        }
        String id = this.getMarkModel().getID();
        int x = this.x - this.xRelativeToCanvas;
        int y = this.y - this.yRelativeToCanvas;
        Color c = this.createColor(this.getMarkModel().hashCode());
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color(this.gc.getDevice(), c.getRed(), c.getGreen(), c.getBlue());
        this.gc.setForeground(color);
        this.gc.setBackground(color);
        Font swtFont = new Font(this.gc.getDevice(), "Arial", 10, 0);
        this.gc.setFont(swtFont);
        this.gc.fillOval(x - 3, y - 3, 6, 6);
        this.gc.drawString(String.valueOf(id), x - 3, y + 6, true);
    }

    @Override
    public MarkModel getMarkModel() {
        return this.parent.getMarkModel();
    }
}

