/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel.tools;

import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.process.MarkModelFactory;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImageComposite;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImagePanelUtil;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenter;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenterFactory;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.AbstractImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ImageInputEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;

public class AddMarkImageTool
extends AbstractImageTool {
    public AddMarkImageTool(Cursor cursor, ImageComposite imgComposite) {
        super(cursor, imgComposite);
    }

    @Override
    protected boolean canHandle(ImageInputEvent ev) {
        return InputEvent.MOUSE_UP.equals((Object)ev.event);
    }

    @Override
    protected boolean executeBehaviour(ImageInputEvent ev) {
        int vScroll;
        int x = ev.x;
        int y = ev.y;
        int hScroll = Math.abs(this.imgComposite.getHScrollValue());
        Point point = ImagePanelUtil.createMarkPosition(hScroll, vScroll = Math.abs(this.imgComposite.getVScrollValue()), x, y, this.imgComposite.getScale());
        if (this.validateInside(point)) {
            this.addMark(x, y, hScroll, vScroll);
            return true;
        }
        return false;
    }

    private void addMark(int x, int y, int hScroll, int vScroll) {
        MarkModel markModel = MarkModelFactory.getInstance().create();
        Point position = ImagePanelUtil.createMarkPosition(hScroll, vScroll, x, y, this.imgComposite.getScale());
        MarkImagePresenter markPresenter = MarkImagePresenterFactory.createMarkPresenter(markModel, position, hScroll, vScroll, this.imgComposite.getCanvas(), this.imgComposite.getScale());
        this.imgComposite.addMarkPresenter(markPresenter);
        this.imgComposite.getCmd().addMark(markModel);
        this.imgComposite.getCmd().evalPrecondition();
        this.imgComposite.getMainComposite().refreshMapGraphicLayer();
    }
}

