/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel.tools;

import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.MouseSelectionListener;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImageComposite;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenter;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ImageInputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ImageTool;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;

abstract class AbstractImageTool
implements ImageTool {
    protected Cursor cursor = null;
    protected ImageComposite imgComposite = null;
    protected boolean active = false;
    protected List<MouseSelectionListener> listeners = new LinkedList<MouseSelectionListener>();

    protected AbstractImageTool(Cursor cursor, ImageComposite imgComposite) {
        this.cursor = cursor;
        this.imgComposite = imgComposite;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean eventHandle(ImageInputEvent ev) {
        if (!this.isActive()) {
            return false;
        }
        if (!this.isScrolling(ev) && !this.canHandle(ev)) {
            return false;
        }
        if (InputEvent.MOUSE_SCROLL.equals((Object)ev.event)) {
            return this.executeMouseScrollBehaviour(ev);
        }
        return this.executeBehaviour(ev);
    }

    private boolean executeMouseScrollBehaviour(ImageInputEvent ev) {
        if (ev.mouseEvent.count == 3) {
            this.scrollZoomIn(ev.x, ev.y);
        } else {
            this.scrollZoomOut(ev.x, ev.y);
        }
        return true;
    }

    private void scrollZoomIn(int x, int y) {
        this.imgComposite.setZoomInFeedback(x, y);
        this.imgComposite.increaseScale(0.1f);
        this.imgComposite.focusPosition(x, y);
    }

    private void scrollZoomOut(int x, int y) {
        this.imgComposite.setZoomOutFeedback(x, y);
        this.imgComposite.decreaseScale(0.1f);
        this.imgComposite.focusPosition(x, y);
    }

    private boolean isScrolling(ImageInputEvent ev) {
        return InputEvent.MOUSE_SCROLL.equals((Object)ev.event);
    }

    protected abstract boolean executeBehaviour(ImageInputEvent var1);

    protected abstract boolean canHandle(ImageInputEvent var1);

    protected void showFeedback(int x, int y, InputEvent inputEvent) {
        for (MarkImagePresenter presenter : this.imgComposite.getMarkPresenterList()) {
            if (presenter.eventHandler(inputEvent, x, y)) {
                presenter.showSelectedFeedback(true);
                this.broadcastMouseInFeedback(presenter.getMarkModel());
                continue;
            }
            presenter.showSelectedFeedback(false);
            this.broadcastMouseOutFeedback(presenter.getMarkModel());
        }
        this.imgComposite.canvasRedraw();
        this.imgComposite.getMainComposite().refreshMapGraphicLayer();
    }

    protected boolean validateInside(Point point) {
        return this.imgComposite.validateInside(point);
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public void addMouseSelectionListener(MouseSelectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void deleteMouseSelectionListener(MouseSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void broadcastMouseInFeedback(MarkModel mark) {
        for (MouseSelectionListener listener : this.listeners) {
            listener.inEvent(mark);
        }
    }

    private void broadcastMouseOutFeedback(MarkModel mark) {
        for (MouseSelectionListener listener : this.listeners) {
            listener.outEvent(mark);
        }
    }
}

