/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel;

import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.AbstractMarkPresenter;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenter;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Observable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MarkImagePresenterImp
extends AbstractMarkPresenter
implements MarkImagePresenter {
    private MarkModel mark;
    private Canvas canvas;
    private GC gc;
    private DrawAction action = DrawAction.NONE;
    private Rectangle extentPointLabel = null;
    private int xRelativeToCanvas;
    private int yRelativeToCanvas;
    private float scale = 1.0f;
    private static int EXTEND_LABEL_WIDTH = 10;
    private static int EXTEND_LABEL_HEIGHT = 25;
    private static final int EXTENT_SIZE = 10;

    public MarkImagePresenterImp(Canvas canvas, MarkModel mark, int xRelativeToCanvas, int yRelativeToCanvas, float scale) {
        assert (mark != null);
        this.canvas = canvas;
        this.mark = mark;
        this.mark.addObserver(this);
        if (Integer.parseInt(mark.getID()) > 99) {
            EXTEND_LABEL_WIDTH = 25;
        } else if (Integer.parseInt(mark.getID()) > 9) {
            EXTEND_LABEL_WIDTH = 15;
        }
        this.extent = new Rectangle(this.mark.getXImage() - 5, this.mark.getYImage() - 5, 10, 10);
        this.extentPointLabel = new Rectangle(this.mark.getXImage() - 3, this.mark.getYImage() - 3, EXTEND_LABEL_WIDTH, EXTEND_LABEL_HEIGHT);
        this.xRelativeToCanvas = xRelativeToCanvas;
        this.yRelativeToCanvas = yRelativeToCanvas;
        this.scale = scale;
        this.createContent(this.canvas);
        this.relocateTheExtend();
    }

    private void createContent(Canvas parent) {
        parent.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                MarkImagePresenterImp.this.gc = event.gc;
                MarkImagePresenterImp.this.relocateTheExtend();
                switch (MarkImagePresenterImp.this.action) {
                    case DELETE: {
                        MarkImagePresenterImp.this.delete();
                        break;
                    }
                    default: {
                        MarkImagePresenterImp.this.draw();
                    }
                }
                MarkImagePresenterImp.this.action = DrawAction.NONE;
            }
        });
    }

    private void relocateTheExtend() {
        this.extentPointLabel.x = Math.round((float)this.mark.getXImage() * this.scale) - 3 - this.xRelativeToCanvas;
        this.extentPointLabel.y = Math.round((float)this.mark.getYImage() * this.scale) - 3 - this.yRelativeToCanvas;
        this.extent.x = Math.round((float)this.mark.getXImage() * this.scale) - 5 - this.xRelativeToCanvas;
        this.extent.y = Math.round((float)this.mark.getYImage() * this.scale) - 5 - this.yRelativeToCanvas;
    }

    @Override
    public void draw() {
        assert (this.gc != null);
        assert (!this.gc.isDisposed());
        if (this.hide) {
            return;
        }
        String id = this.mark.getID();
        int x = this.getX();
        int y = this.getY();
        Color c = this.createColor(this.mark.hashCode());
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color(this.gc.getDevice(), c.getRed(), c.getGreen(), c.getBlue());
        this.gc.setForeground(color);
        this.gc.setBackground(color);
        Font swtFont = new Font(this.gc.getDevice(), "Arial", 10, 0);
        this.gc.setFont(swtFont);
        if (this.feedback) {
            Color yellow = Color.YELLOW;
            org.eclipse.swt.graphics.Color coloryellow = new org.eclipse.swt.graphics.Color(this.gc.getDevice(), yellow.getRed(), yellow.getGreen(), yellow.getBlue());
            this.gc.setForeground(coloryellow);
            this.gc.setBackground(coloryellow);
            this.gc.fillOval(x - 3, y - 3, 6, 6);
            Color orange = Color.ORANGE;
            org.eclipse.swt.graphics.Color colorOrange = new org.eclipse.swt.graphics.Color(this.gc.getDevice(), orange.getRed(), orange.getGreen(), orange.getBlue());
            this.gc.setForeground(colorOrange);
            this.gc.drawOval(x - 3, y - 3, 6, 6);
            this.gc.setForeground(color);
            this.gc.setBackground(color);
        } else {
            this.gc.fillOval(x - 3, y - 3, 6, 6);
        }
        this.gc.drawString(String.valueOf(id), x - 3, y + 6, true);
    }

    private int getX() {
        int x = Math.round((float)this.mark.getXImage() * this.scale) - this.xRelativeToCanvas;
        return x;
    }

    private int getY() {
        int y = Math.round((float)this.mark.getYImage() * this.scale) - this.yRelativeToCanvas;
        return y;
    }

    @Override
    public void update(Observable o, Object arg) {
        MarkModel.MarkModelChange change = (MarkModel.MarkModelChange)((Object)arg);
        switch (change) {
            case NEW: {
                this.action = DrawAction.NEW;
                break;
            }
            case MODIFY: {
                this.action = DrawAction.MOVE;
                break;
            }
            case DELETE: {
                this.action = DrawAction.DELETE;
                break;
            }
            default: {
                return;
            }
        }
        this.relocateTheExtend();
        this.canvas.redraw(this.extentPointLabel.x, this.extentPointLabel.y, EXTEND_LABEL_WIDTH, EXTEND_LABEL_HEIGHT, false);
    }

    @Override
    public MarkModel getMarkModel() {
        return this.mark;
    }

    @Override
    public boolean eventHandler(InputEvent event, int x, int y) {
        switch (event) {
            case MOUSE_DOWN: 
            case MOUSE_DRAG: 
            case DELETE: 
            case MOUSE_OVER: {
                return this.extentContains(x, y);
            }
            case PAN: {
                this.scroll(x, y);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean eventHandler(InputEvent event, float scale) {
        switch (event) {
            case ZOOM: {
                this.zoom(scale);
                break;
            }
        }
        return false;
    }

    private void scroll(int x, int y) {
        this.xRelativeToCanvas = x;
        this.yRelativeToCanvas = y;
        this.action = DrawAction.SCROLL;
    }

    private void zoom(float scale) {
        this.scale = scale;
        this.action = DrawAction.ZOOM;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public int getXRelativeToCanvas() {
        return this.xRelativeToCanvas;
    }

    public int getYRelativeToCanvas() {
        return this.yRelativeToCanvas;
    }

    private static enum DrawAction {
        MOVE,
        DELETE,
        SCROLL,
        NEW,
        NONE,
        ZOOM;

    }
}

