/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.coordinatepanel;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.image.georeferencing.internal.i18n.Messages;
import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.GeoReferencingCommand;
import eu.udig.image.georeferencing.internal.ui.GeoReferencingComposite;
import eu.udig.image.georeferencing.internal.ui.GeoreferencingCommandEventChange;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.MainComposite;
import eu.udig.image.georeferencing.internal.ui.MouseSelectionListener;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.MarkMapPresenter;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.MarkMapPresenterImp;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.AddCoordinateTool;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.CapturedCoordinateListener;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.CoordToolPropertyValue;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.DeleteCoordinateTool;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.DeletedCoordinateListener;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.MoveCoordinateListener;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.MoveCoordinateTool;
import eu.udig.image.georeferencing.internal.ui.message.InfoMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.impl.EditManagerImpl;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.Tool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class CoordinateTableComposite
extends Composite
implements Observer,
GeoReferencingComposite {
    private CLabel crsLabel = null;
    private CLabel mapLabel;
    private Table coordinatesTable = null;
    private Composite compositeGridCoord = null;
    private GeoReferencingCommand cmd = null;
    private IToolContext toolContext = null;
    private TableColumn tableColumnX = null;
    private TableColumn tableColumnY = null;
    private TableColumn tableColumnID = null;
    private TableEditor editorX = null;
    private TableEditor editorY = null;
    private Thread uiThread = null;
    private CapturedCoordinateListener capturedListener = null;
    private DeletedCoordinateListener deletedListener = null;
    private MoveCoordinateListener moveListener = null;
    private MouseSelectionListener mapSelectionListener = null;
    private MouseSelectionListener imageSelectionListener = null;
    private AddCoordinateTool addTool = null;
    private DeleteCoordinateTool deleteTool = null;
    private MoveCoordinateTool moveTool = null;
    private ToolBar mapToolBar = null;
    private ImageRegistry registry = null;
    private List<MouseSelectionListener> listeners = new LinkedList<MouseSelectionListener>();
    private ToolItem itemDeleteAll;

    public CoordinateTableComposite(GeoReferencingCommand cmd, Composite parent, int style) {
        super(parent, style);
        assert (cmd != null);
        this.cmd = cmd;
        this.createContent();
    }

    private void createContent() {
        this.registry = this.createImageRegistry();
        this.uiThread = Thread.currentThread();
        this.createListeners();
        this.setCoordinateTools();
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.makeColumnsEqualWidth = true;
        this.compositeGridCoord = new Composite((Composite)this, 2048);
        this.compositeGridCoord.setLayout((Layout)gridLayout2);
        this.createCRSselector(this.compositeGridCoord);
        this.createToolbar(this.compositeGridCoord);
        this.createGrid(this.compositeGridCoord);
    }

    private void createListeners() {
        this.capturedListener = new CapturedCoordinateListener(){

            @Override
            public void capturedCoordinate(Coordinate newCoord) {
                CoordinateTableComposite.this.addCoordinateFromMapToTable(newCoord);
                if (!$assertionsDisabled && CoordinateTableComposite.this.getMainComposite().getMapMarkGraphic() == null) {
                    throw new AssertionError();
                }
                CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
            }

            @Override
            public void activated(boolean active) {
            }
        };
        this.deletedListener = new DeletedCoordinateListener(){

            @Override
            public void deletedCoordinate(java.awt.Point point, InputEvent event) {
                CoordinateTableComposite.this.deleteFromTable(point, event);
                if (!$assertionsDisabled && CoordinateTableComposite.this.getMainComposite().getMapMarkGraphic() == null) {
                    throw new AssertionError();
                }
                CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
            }

            @Override
            public void activated(boolean active) {
            }
        };
        this.moveListener = new MoveCoordinateListener(){

            @Override
            public void MoveCoordinate(java.awt.Point coor, InputEvent event) {
                CoordinateTableComposite.this.moveFromTable(coor, event);
                if (!$assertionsDisabled && CoordinateTableComposite.this.getMainComposite().getMapMarkGraphic() == null) {
                    throw new AssertionError();
                }
                CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
            }

            @Override
            public void activated(boolean active) {
            }
        };
        this.mapSelectionListener = new MouseSelectionListener(){

            @Override
            public void inEvent(MarkModel mark) {
                CoordinateTableComposite.this.selectRow(mark);
            }

            @Override
            public void outEvent(MarkModel mark) {
                CoordinateTableComposite.this.deselectRow(mark);
            }
        };
        this.imageSelectionListener = new MouseSelectionListener(){

            @Override
            public void inEvent(MarkModel mark) {
                CoordinateTableComposite.this.selectRow(mark);
            }

            @Override
            public void outEvent(MarkModel mark) {
                CoordinateTableComposite.this.deselectRow(mark);
            }
        };
    }

    private ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry(this.getDisplay());
        String opId = "Delete";
        String imgFile = "image/delete.gif";
        registry.put(opId, ImageDescriptor.createFromFile(CoordinateTableComposite.class, (String)imgFile));
        opId = "Add";
        imgFile = "image/add.png";
        registry.put(opId, ImageDescriptor.createFromFile(CoordinateTableComposite.class, (String)imgFile));
        opId = "Move";
        imgFile = "image/movemarker.png";
        registry.put(opId, ImageDescriptor.createFromFile(CoordinateTableComposite.class, (String)imgFile));
        opId = "DeleteAll";
        imgFile = "image/deleteAll.gif";
        registry.put(opId, ImageDescriptor.createFromFile(CoordinateTableComposite.class, (String)imgFile));
        return registry;
    }

    private void setCoordinateTools() {
        Tool tool = ApplicationGIS.getToolManager().findTool("eu.udig.image.georeferencing.tools.addcoordinate");
        this.addTool = (AddCoordinateTool)tool;
        this.addTool.addCapturedCoordinateListener(this.capturedListener);
        tool = ApplicationGIS.getToolManager().findTool("eu.udig.image.georeferencing.tools.deletecoordinate");
        this.deleteTool = (DeleteCoordinateTool)tool;
        this.deleteTool.addDeletedCoordinateListener(this.deletedListener);
        tool = ApplicationGIS.getToolManager().findTool("eu.udig.image.georeferencing.tools.movecoordinate");
        this.moveTool = (MoveCoordinateTool)tool;
        this.moveTool.addMoveCoordinateListener(this.moveListener);
    }

    private void createCRSselector(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 4;
        this.mapLabel = new CLabel(parent, 0);
        this.mapLabel.setText(Messages.CoordinateTableComposite_map);
        this.mapLabel.setLayoutData((Object)gridData);
        this.crsLabel = new CLabel(parent, 0);
        this.crsLabel.setText("CRS:");
        this.crsLabel.setLayoutData((Object)gridData);
    }

    private void createToolbar(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 4;
        this.mapToolBar = new ToolBar(parent, 0x2000000);
        this.itemDeleteAll = new ToolItem(this.mapToolBar, 8);
        this.itemDeleteAll.setImage(this.registry.get("DeleteAll"));
        this.itemDeleteAll.setToolTipText(Messages.CoordinateTableComposite_itemDeleteAll_Tooltip);
        this.itemDeleteAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CoordinateTableComposite.this.deleteAllGCP();
            }
        });
        this.setItemsEnabled(false);
        this.setCertainItemsEnabled(false);
        CoordToolPropertyValue.setVisible(true);
    }

    private void setItemsEnabled(boolean enabled) {
    }

    private void setCertainItemsEnabled(boolean enabled) {
        this.itemDeleteAll.setEnabled(enabled);
        if (!enabled) {
            this.itemDeleteAll.setSelection(false);
        }
    }

    private void createGrid(final Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 4;
        this.coordinatesTable = new Table(parent, 101124);
        this.coordinatesTable.setHeaderVisible(true);
        this.coordinatesTable.setLayoutData((Object)gridData);
        this.coordinatesTable.setLinesVisible(true);
        this.tableColumnID = new TableColumn(this.coordinatesTable, 0);
        this.tableColumnID.setWidth(45);
        this.tableColumnID.setText("ID");
        this.tableColumnID.setMoveable(true);
        this.tableColumnID.setResizable(true);
        this.tableColumnX = new TableColumn(this.coordinatesTable, 0);
        this.tableColumnX.setText("X");
        this.tableColumnX.setMoveable(true);
        this.tableColumnX.setResizable(true);
        this.tableColumnY = new TableColumn(this.coordinatesTable, 0);
        this.tableColumnY.setText("Y");
        this.tableColumnY.setMoveable(true);
        this.tableColumnY.setResizable(true);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point size = CoordinateTableComposite.this.coordinatesTable.computeSize(-1, -1);
                ScrollBar vBar = CoordinateTableComposite.this.coordinatesTable.getVerticalBar();
                int width = area.width - ((CoordinateTableComposite)CoordinateTableComposite.this).coordinatesTable.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + CoordinateTableComposite.this.coordinatesTable.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = CoordinateTableComposite.this.coordinatesTable.getSize();
                if (oldSize.x > area.width) {
                    CoordinateTableComposite.this.tableColumnX.setWidth(width / 3);
                    CoordinateTableComposite.this.tableColumnY.setWidth(width - CoordinateTableComposite.this.tableColumnX.getWidth());
                    CoordinateTableComposite.this.coordinatesTable.setSize(area.width, area.height);
                } else {
                    CoordinateTableComposite.this.coordinatesTable.setSize(area.width, area.height);
                    CoordinateTableComposite.this.tableColumnX.setWidth(width / 3);
                    CoordinateTableComposite.this.tableColumnY.setWidth(width - CoordinateTableComposite.this.tableColumnX.getWidth());
                }
            }
        });
        this.editorX = new TableEditor(this.coordinatesTable);
        this.editorX.horizontalAlignment = 16384;
        this.editorX.grabHorizontal = true;
        this.editorX.minimumWidth = 50;
        this.editorY = new TableEditor(this.coordinatesTable);
        this.editorY.horizontalAlignment = 16384;
        this.editorY.grabHorizontal = true;
        this.editorY.minimumWidth = 50;
        this.coordinatesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoordinateTableComposite.this.deleteOldEditors();
                TableItem item = (TableItem)e.item;
                if (item == null) {
                    return;
                }
                MarkModel mark = (MarkModel)item.getData();
                CoordinateTableComposite.this.createEditorColumnX(mark, item);
                CoordinateTableComposite.this.createEditorColumnY(mark, item);
                CoordinateTableComposite.this.broadcastSelectionInEvent(mark);
                CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
            }
        });
    }

    private void createEditorColumnX(final MarkModel mark, final TableItem item) {
        Text editorColumnX = new Text((Composite)this.coordinatesTable, 0);
        if (mark != null && !mark.getXCoord().equals(Double.NaN)) {
            editorColumnX.setText(String.valueOf(mark.getXCoord()));
        }
        editorColumnX.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)CoordinateTableComposite.this.editorX.getEditor();
                String newText = text.getText();
                if (mark != null) {
                    try {
                        Double value = Double.parseDouble(newText);
                        mark.setXCoord(value);
                        CoordinateTableComposite.this.cmd.evalPrecondition();
                        CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (newText.equals("")) {
                            mark.setXCoord(Double.NaN);
                        } else {
                            newText = String.valueOf(mark.getXCoord());
                        }
                        CoordinateTableComposite.this.cmd.evalPrecondition();
                        CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
                    }
                }
                item.setText(1, newText);
            }
        });
        editorColumnX.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                try {
                    CoordinateTableComposite.this.validateCharacter(e);
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        editorColumnX.selectAll();
        editorColumnX.setFocus();
        this.editorX.setEditor((Control)editorColumnX, item, 1);
    }

    private void createEditorColumnY(final MarkModel mark, final TableItem item) {
        Text editorColumnY = new Text((Composite)this.coordinatesTable, 0);
        if (mark != null && !mark.getYCoord().equals(Double.NaN)) {
            editorColumnY.setText(String.valueOf(mark.getYCoord()));
        }
        editorColumnY.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)CoordinateTableComposite.this.editorY.getEditor();
                String newText = text.getText();
                if (mark != null) {
                    try {
                        Double value = Double.parseDouble(newText);
                        mark.setYCoord(value);
                        CoordinateTableComposite.this.cmd.evalPrecondition();
                        CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (newText.equals("")) {
                            mark.setYCoord(Double.NaN);
                        } else {
                            newText = String.valueOf(mark.getYCoord());
                        }
                        CoordinateTableComposite.this.cmd.evalPrecondition();
                        CoordinateTableComposite.this.getMainComposite().refreshMapGraphicLayer();
                    }
                }
                item.setText(2, newText);
            }
        });
        editorColumnY.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                try {
                    CoordinateTableComposite.this.validateCharacter(e);
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        this.editorY.setEditor((Control)editorColumnY, item, 2);
    }

    private void deleteOldEditors() {
        Control oldEditorY;
        Control oldEditorX = this.editorX.getEditor();
        if (oldEditorX != null) {
            oldEditorX.dispose();
        }
        if ((oldEditorY = this.editorY.getEditor()) != null) {
            oldEditorY.dispose();
        }
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof GeoReferencingCommand) {
            this.setCertainItemsEnabled(this.cmd.canEnableMapTools());
            GeoreferencingCommandEventChange cmdEvent = (GeoreferencingCommandEventChange)arg;
            MarkModel mark = cmdEvent.getMark();
            switch (cmdEvent.getEvent()) {
                case MARK_ADDED: {
                    this.addMarkOnTable(mark);
                    break;
                }
                case MARK_DELETED: {
                    this.deleteMarkOnTable(mark);
                    break;
                }
                case ALL_MARKS_DELETED: {
                    this.deleteAllMarksOnTable();
                    break;
                }
            }
        } else if (obs instanceof MarkModel) {
            MarkModel mark = (MarkModel)((Object)obs);
            MarkModel.MarkModelChange event = (MarkModel.MarkModelChange)((Object)arg);
            switch (event) {
                case MODIFY: {
                    this.modifyCoordinateOnTable(mark);
                    break;
                }
            }
        }
    }

    private void modifyCoordinateOnTable(MarkModel mark) {
        TableItem[] items;
        boolean selection = false;
        TableItem[] selectedItems = this.coordinatesTable.getSelection();
        if (selectedItems.length > 0) {
            selection = true;
        }
        TableItem[] tableItemArray = items = this.coordinatesTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            MarkModel compareMark = (MarkModel)item.getData();
            if (mark.equals(compareMark)) {
                Coordinate newCoord = new Coordinate(mark.getXCoord().doubleValue(), mark.getYCoord().doubleValue());
                if (selection && selectedItems[0].equals(item)) {
                    this.createEditorsAndSetText(mark, item, newCoord);
                }
                this.setRowData(item, mark, newCoord);
            }
            ++n2;
        }
    }

    private void createEditorsAndSetText(MarkModel mark, TableItem item, Coordinate newCoord) {
        this.deleteOldEditors();
        this.createEditorColumnX(mark, item);
        this.createEditorColumnY(mark, item);
        Text textX = (Text)this.editorX.getEditor();
        Text textY = (Text)this.editorY.getEditor();
        if (!Double.isNaN(newCoord.x)) {
            textX.setText(String.valueOf(newCoord.x));
        }
        if (!Double.isNaN(newCoord.y)) {
            textY.setText(String.valueOf(newCoord.y));
        }
    }

    private void addMarkOnTable(MarkModel mark) {
        TableItem tableItem = new TableItem(this.coordinatesTable, 0);
        tableItem.setData((Object)mark);
        tableItem.setText(0, String.valueOf(mark.getID()));
        if (!mark.getXCoord().equals(Double.NaN)) {
            tableItem.setText(1, String.valueOf(mark.getXCoord()));
        }
        if (!mark.getYCoord().equals(Double.NaN)) {
            tableItem.setText(2, String.valueOf(mark.getYCoord()));
        }
        this.updateRowSelection(tableItem, mark);
        assert (this.getMainComposite().getMapMarkGraphic() != null);
        MarkMapPresenterImp markPresenter = new MarkMapPresenterImp(mark);
        this.getMainComposite().getMapMarkGraphic().addMarkMapPresenter(markPresenter);
        this.setItemsEnabled(true);
        mark.addObserver(this);
    }

    private void updateRowSelection(TableItem addedItem, MarkModel mark) {
        TableItem[] selection = this.coordinatesTable.getSelection();
        if (selection.length > 0) {
            this.coordinatesTable.setSelection(addedItem);
            this.deleteOldEditors();
            this.createEditorColumnX(mark, addedItem);
            this.createEditorColumnY(mark, addedItem);
        }
    }

    private void addCoordinateFromMapToTable(Coordinate newCoord) {
        TableItem[] selection = this.coordinatesTable.getSelection();
        if (selection.length > 0) {
            TableItem item = selection[0];
            this.addCoordinateOnTable(item, newCoord, true);
        } else {
            TableItem[] items;
            boolean added = false;
            TableItem[] tableItemArray = items = this.coordinatesTable.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                added = this.addCoordinateOnTable(item, newCoord, false);
                if (added) {
                    return;
                }
                ++n2;
            }
            this.getMainComposite().setMessage(new InfoMessage(Messages.CoordinateTableComposite_cant_add_gcp, InfoMessage.Type.WARNING));
        }
    }

    private MainComposite getMainComposite() {
        if (this.isDisposed()) {
            return null;
        }
        Composite parent = this.getParent();
        while (!(parent instanceof MainComposite)) {
            parent = parent.getParent();
        }
        return (MainComposite)parent;
    }

    private void validateCharacter(KeyEvent e) throws NumberFormatException {
        if (e.character == '.' || e.keyCode == 127 || e.keyCode == 8 || e.keyCode == 0x1000008 || e.keyCode == 0x1000007 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.character == '-' || e.character == '+') {
            return;
        }
        Integer.parseInt(String.valueOf(e.character));
    }

    private void deleteMarkOnTable(MarkModel mark) {
        int index = this.getMarkIndexWithinTheTable(mark);
        this.deleteOldEditors();
        this.coordinatesTable.remove(index);
        this.getMainComposite().refreshMapGraphicLayer();
        mark.deleteObserver(this);
    }

    private int getMarkIndexWithinTheTable(MarkModel mark) {
        TableItem[] items;
        int index = -1;
        TableItem[] tableItemArray = items = this.coordinatesTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ++index;
            MarkModel itemMark = (MarkModel)item.getData();
            if (mark.equals(itemMark)) break;
            ++n2;
        }
        assert (index != -1) : "index can't be null, it must have found the given mark.";
        return index;
    }

    private void deleteAllMarksOnTable() {
        this.deleteOldEditors();
        TableItem[] items = this.coordinatesTable.getItems();
        this.coordinatesTable.remove(0, items.length - 1);
        assert (this.coordinatesTable.getItems().length == 0);
        this.getMainComposite().getMapMarkGraphic().clear();
    }

    private boolean addCoordinateOnTable(TableItem item, Coordinate newCoord, boolean existSelection) {
        MarkModel mark = (MarkModel)item.getData();
        if (existSelection) {
            this.createEditorsAndSetText(mark, item, newCoord);
            this.setRowData(item, mark, newCoord);
        } else if (mark.getXCoord().equals(Double.NaN) && mark.getYCoord().equals(Double.NaN)) {
            this.setRowData(item, mark, newCoord);
            return true;
        }
        return false;
    }

    private void setRowData(TableItem item, MarkModel mark, Coordinate newCoord) {
        if (!Double.isNaN(newCoord.x)) {
            item.setText(1, String.valueOf(newCoord.x));
        } else {
            item.setText(1, "");
        }
        if (!Double.isNaN(newCoord.y)) {
            item.setText(2, String.valueOf(newCoord.y));
        } else {
            item.setText(2, "");
        }
        mark.setXCoord(newCoord.x);
        mark.setYCoord(newCoord.y);
        this.cmd.evalPrecondition();
    }

    @Override
    public void setContext(IToolContext newContext) {
        if (this.toolContext == null) {
            this.getMainComposite().getMapMarkGraphic().addMouseSelectionListener(this.mapSelectionListener);
            this.getMainComposite().addMouseSelectionListenerToImgComposite(this.imageSelectionListener);
        }
        this.toolContext = newContext;
        if (this.toolContext != null) {
            IMap map = this.toolContext.getMap();
            this.mapLabel.setText("Map: " + map.getName());
            CoordinateReferenceSystem crs = this.getCurrentMapCrs(map);
            this.crsLabel.setText("CRS: " + crs.getName().toString());
        }
    }

    private CoordinateReferenceSystem getCurrentMapCrs(IMap map) {
        IViewportModel viewportModel = map.getViewportModel();
        CoordinateReferenceSystem mapCrs = viewportModel.getCRS();
        return mapCrs;
    }

    public void close(MainComposite mainComposite) {
        this.hideCoordinateTools();
        this.addTool.removeCapturedCoordinateListener(this.capturedListener);
        this.deleteTool.removeDeletedCoordinateListener(this.deletedListener);
        this.moveTool.removeMoveCoordinateListener(this.moveListener);
        this.addTool.setActive(false);
        this.deleteTool.setActive(false);
        this.moveTool.setActive(false);
        if (this.toolContext != null) {
            mainComposite.getMapMarkGraphic().deleteMouseSelectionListener(this.mapSelectionListener);
            mainComposite.deleteMouseSelectionListenerToImgComposite(this.imageSelectionListener);
        }
    }

    private void hideCoordinateTools() {
        CoordToolPropertyValue.setVisible(false);
        EditManagerImpl editManager = (EditManagerImpl)ApplicationGIS.getActiveMap().getEditManager();
        Layer layer = editManager.getSelectedLayer();
        editManager.setSelectedLayerGen(layer);
    }

    public void setEnabled(boolean enabled) {
        this.coordinatesTable.setEnabled(enabled);
        if (this.editorX.getEditor() != null && !this.editorX.getEditor().isDisposed()) {
            this.editorX.getEditor().setEnabled(enabled);
        }
        if (this.editorY.getEditor() != null && !this.editorY.getEditor().isDisposed()) {
            this.editorY.getEditor().setEnabled(enabled);
        }
        this.setItemsEnabled(enabled);
        this.setCertainItemsEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void deleteFromTable(java.awt.Point point, InputEvent event) {
        if (InputEvent.MOUSE_DOWN.equals((Object)event)) {
            Map<String, MarkMapPresenter> presenters = this.getMainComposite().getMapMarkGraphic().getPresenters();
            MarkModel mark = null;
            Set<Map.Entry<String, MarkMapPresenter>> entrySet = presenters.entrySet();
            for (Map.Entry<String, MarkMapPresenter> entry : entrySet) {
                MarkMapPresenter mapPresenter = entry.getValue();
                if (!mapPresenter.eventHandler(InputEvent.DELETE, point.x, point.y)) continue;
                mark = mapPresenter.getMarkModel();
                break;
            }
            if (mark != null) {
                this.deleteOldEditors();
                int index = this.getMarkIndexWithinTheTable(mark);
                TableItem item = this.coordinatesTable.getItem(index);
                item.setText(1, "");
                item.setText(2, "");
                mark.setXCoord(Double.NaN);
                mark.setYCoord(Double.NaN);
                this.cmd.evalPrecondition();
                this.getMainComposite().refreshMapGraphicLayer();
            }
        } else {
            this.getMainComposite().getMapMarkGraphic().eventhandler(event, point);
        }
    }

    private void moveFromTable(java.awt.Point point, InputEvent event) {
        this.getMainComposite().getMapMarkGraphic().eventhandler(event, point);
    }

    private void selectRow(MarkModel mark) {
        this.deleteOldEditors();
        int index = this.getMarkIndexWithinTheTable(mark);
        assert (index >= 0);
        this.coordinatesTable.setSelection(index);
        this.createEditorColumnX(mark, this.coordinatesTable.getSelection()[0]);
        this.createEditorColumnY(mark, this.coordinatesTable.getSelection()[0]);
    }

    private void deselectRow(MarkModel mark) {
        int selection;
        int index = this.getMarkIndexWithinTheTable(mark);
        if (index == (selection = this.coordinatesTable.getSelectionIndex())) {
            this.coordinatesTable.deselect(selection);
            this.deleteOldEditors();
        }
    }

    public void addMouseSelectionListener(MouseSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void deleteMouseSelectionListener(MouseSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void broadcastSelectionInEvent(MarkModel mark) {
        for (MouseSelectionListener listener : this.listeners) {
            listener.inEvent(mark);
        }
    }

    private void deleteAllGCP() {
        TableItem[] items;
        Coordinate emptyCoord = new Coordinate(Double.NaN, Double.NaN);
        TableItem[] tableItemArray = items = this.coordinatesTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            MarkModel itemMark = (MarkModel)item.getData();
            itemMark.updateCoordinatePosition(emptyCoord);
            ++n2;
        }
        this.getMainComposite().refreshMapGraphicLayer();
    }
}

