/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.process;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.image.georeferencing.internal.process.MarkModel;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.graphics.Point;

final class MarkModelImpl
extends Observable
implements Serializable,
MarkModel {
    private static final long serialVersionUID = 4462169346430911665L;
    private int xImage;
    private int yImage;
    private Double xCoord = Double.NaN;
    private Double yCoord = Double.NaN;
    private String ID;

    public MarkModelImpl(String newMarkID) {
        this.ID = newMarkID;
    }

    @Override
    public int getXImage() {
        return this.xImage;
    }

    @Override
    public void setXImage(int xImage) {
        this.xImage = xImage;
    }

    @Override
    public int getYImage() {
        return this.yImage;
    }

    @Override
    public void setYImage(int yImage) {
        this.yImage = yImage;
    }

    @Override
    public Double getXCoord() {
        return this.xCoord;
    }

    @Override
    public void setXCoord(Double xCoord) {
        this.xCoord = xCoord;
    }

    @Override
    public Double getYCoord() {
        return this.yCoord;
    }

    @Override
    public void setYCoord(Double yCoord) {
        this.yCoord = yCoord;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    @Override
    public void initializeImagePosition(Point point) {
        this.xImage = point.x;
        this.yImage = point.y;
        this.setChanged();
        this.notifyObservers((Object)MarkModel.MarkModelChange.NEW);
    }

    @Override
    public void updateImagePosition(Point point) {
        this.xImage = point.x;
        this.yImage = point.y;
        this.setChanged();
        this.notifyObservers((Object)MarkModel.MarkModelChange.MODIFY);
    }

    @Override
    public void updateCoordinatePosition(Coordinate coord) {
        this.xCoord = coord.x;
        this.yCoord = coord.y;
        this.setChanged();
        this.notifyObservers((Object)MarkModel.MarkModelChange.MODIFY);
    }

    @Override
    public Point getImagePosition() {
        return new Point(this.xImage, this.yImage);
    }

    @Override
    public void delete() {
        this.setChanged();
        this.notifyObservers((Object)MarkModel.MarkModelChange.DELETE);
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getID());
        builder.append(";");
        builder.append(this.getXImage());
        builder.append(";");
        builder.append(this.getYImage());
        builder.append(";");
        builder.append(this.getXCoord());
        builder.append(";");
        builder.append(this.getYCoord());
        return builder.toString();
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
    }

    @Override
    public void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
    }
}

