/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.geotiff;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.geotiff.internal.Messages;
import net.refractions.udig.catalog.internal.geotiff.GeoTiffGeoResourceImpl;
import net.refractions.udig.catalog.internal.geotiff.GeoTiffServiceExtension;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResource;
import net.refractions.udig.catalog.rasterings.AbstractRasterService;
import net.refractions.udig.catalog.rasterings.AbstractRasterServiceInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.gce.geotiff.GeoTiffFormat;

public class GeoTiffServiceImpl
extends AbstractRasterService {
    public GeoTiffServiceImpl(URL id, GridFormatFactorySpi factory) {
        super(id, "geotiff", factory);
    }

    public synchronized List<AbstractRasterGeoResource> resources(IProgressMonitor monitor) throws IOException {
        if (monitor != null) {
            String msg = MessageFormat.format(Messages.GeoTiffServiceImpl_connecting_to, new Object[0]);
            monitor.beginTask(msg, 5);
        }
        if (this.reader != null && monitor != null) {
            monitor.worked(3);
        }
        GeoTiffGeoResourceImpl res = new GeoTiffGeoResourceImpl(this, this.getHandle());
        ArrayList<AbstractRasterGeoResource> list = new ArrayList<AbstractRasterGeoResource>();
        list.add(res);
        if (monitor != null) {
            monitor.done();
        }
        return list;
    }

    public Map<String, Serializable> getConnectionParams() {
        return new GeoTiffServiceExtension().createParams(this.getIdentifier());
    }

    public synchronized AbstractGridCoverage2DReader getReader() {
        if (this.reader == null) {
            try {
                File file = new File(this.getIdentifier().toURI());
                GeoTiffFormat geoTiffFormat = (GeoTiffFormat)this.getFormat();
                this.reader = geoTiffFormat.getReader((Object)file);
            }
            catch (Exception ex) {
                this.message = ex;
            }
        }
        return this.reader;
    }

    protected synchronized AbstractRasterServiceInfo createInfo(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.GeoTiffServiceImpl_loading_task_title, 2);
            monitor.worked(1);
            AbstractRasterServiceInfo abstractRasterServiceInfo = new AbstractRasterServiceInfo((AbstractRasterService)this, new String[]{"geotiff", "tiff", "tif"});
            return abstractRasterServiceInfo;
        }
        finally {
            monitor.done();
        }
    }
}

