/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.core.internal.GeometryBuilder;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.AdaptorFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;

public class FeatureUtils {
    private static GeometryBuilder geomBuilder = GeometryBuilder.create();

    public static <T extends Geometry> SimpleFeature createFeature(CoordinateReferenceSystem coordCRS, CoordinateReferenceSystem destinationCRS, SimpleFeatureType type, Coordinate[] coordinates, Class<T> geomType) throws Exception {
        FeatureUtils.transform(coordCRS, destinationCRS, coordinates);
        Object[] attrs = new Object[type.getAttributeCount()];
        int i = 0;
        while (i < attrs.length) {
            attrs[i] = FeatureUtils.setDefaultValue(type.getDescriptor(i));
            ++i;
        }
        SimpleFeature newFeature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])attrs, null);
        T geom = GeometryBuilder.create().safeCreateGeometry(geomType, coordinates);
        newFeature.setDefaultGeometry(geom);
        return newFeature;
    }

    private static Object setDefaultValue(AttributeDescriptor type) {
        if (type.getDefaultValue() != null) {
            return type.getDefaultValue();
        }
        if (Boolean.class.isAssignableFrom(type.getType().getBinding()) || Boolean.TYPE.isAssignableFrom(type.getType().getBinding())) {
            return false;
        }
        if (String.class.isAssignableFrom(type.getType().getBinding())) {
            return "";
        }
        if (Integer.class.isAssignableFrom(type.getType().getBinding())) {
            return 0;
        }
        if (Double.class.isAssignableFrom(type.getType().getBinding())) {
            return 0.0;
        }
        if (Float.class.isAssignableFrom(type.getType().getBinding())) {
            return Float.valueOf(0.0f);
        }
        if (CodeList.class.isAssignableFrom(type.getType().getBinding())) {
            return type.getDefaultValue();
        }
        return null;
    }

    private static void transform(CoordinateReferenceSystem coordCRS, CoordinateReferenceSystem destinationCRS, Coordinate[] coordinates) throws Exception {
        if (coordCRS == null || destinationCRS == null) {
            return;
        }
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)coordCRS, (CoordinateReferenceSystem)destinationCRS, (boolean)true);
        if (mt == null || mt.isIdentity()) {
            return;
        }
        double[] coords = new double[coordinates.length * 2];
        int i = 0;
        while (i < coordinates.length) {
            coords[i * 2] = coordinates[i].x;
            coords[i * 2 + 1] = coordinates[i].y;
            ++i;
        }
        mt.transform(coords, 0, coords, 0, coordinates.length);
        i = 0;
        while (i < coordinates.length) {
            coordinates[i].x = coords[i * 2];
            coordinates[i].y = coords[i * 2 + 1];
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int same(SimpleFeature feature1, SimpleFeature feature2) {
        if (DataUtilities.compare((SimpleFeatureType)feature1.getFeatureType(), (SimpleFeatureType)feature2.getFeatureType()) != 0) {
            return -1;
        }
        int i = 0;
        while (i < feature1.getAttributeCount()) {
            if (feature1.getAttribute(i) == null) {
                if (feature2.getAttribute(i) != null) {
                    return -1;
                }
            } else if (feature1.getAttribute(i) instanceof Geometry) {
                Geometry geom1 = (Geometry)feature1.getAttribute(i);
                if (!(feature2.getAttribute(i) instanceof Geometry)) return -1;
                Geometry geom2 = (Geometry)feature2.getAttribute(i);
                if (!geom1.equalsExact(geom2)) return -1;
            } else if (!feature1.getAttribute(i).equals(feature2.getAttribute(i))) {
                return -1;
            }
            ++i;
        }
        if (!feature1.getID().equals(feature2.getID())) return 1;
        return 0;
    }

    public static Map<String, String> createAttributeMapping(SimpleFeatureType sourceSchema, SimpleFeatureType targetSchema) {
        HashMap<String, String> queryAttributes = new HashMap<String, String>();
        FeatureUtils.performDirectMapping(sourceSchema, targetSchema, queryAttributes);
        FeatureUtils.mapGeometryAttributes(sourceSchema, targetSchema, queryAttributes);
        return queryAttributes;
    }

    private static void mapGeometryAttributes(SimpleFeatureType sourceSchema, SimpleFeatureType targetSchema, Map<String, String> queryAttributes) {
        GeometryDescriptor defaultGeometry = targetSchema.getGeometryDescriptor();
        if (defaultGeometry == null) {
            return;
        }
        if (!queryAttributes.containsKey(defaultGeometry.getName())) {
            Class binding = sourceSchema.getGeometryDescriptor().getType().getBinding();
            if (defaultGeometry.getType().getBinding().isAssignableFrom(binding)) {
                queryAttributes.put(defaultGeometry.getName().getLocalPart(), sourceSchema.getGeometryDescriptor().getName().getLocalPart());
            } else {
                boolean found = false;
                int i = 0;
                while (i < sourceSchema.getAttributeCount()) {
                    AttributeDescriptor source = sourceSchema.getDescriptor(i);
                    if (defaultGeometry.getType().getBinding().isAssignableFrom(source.getType().getBinding())) {
                        queryAttributes.put(defaultGeometry.getName().getLocalPart(), source.getName().getLocalPart());
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    queryAttributes.put(defaultGeometry.getName().getLocalPart(), sourceSchema.getGeometryDescriptor().getName().getLocalPart());
                }
            }
        }
    }

    private static void performDirectMapping(SimpleFeatureType sourceSchema, SimpleFeatureType targetSchema, Map<String, String> queryAttributes) {
        int i = 0;
        while (i < sourceSchema.getAttributeCount()) {
            AttributeDescriptor source = sourceSchema.getDescriptor(i);
            int j = 0;
            while (j < targetSchema.getAttributeCount()) {
                AttributeDescriptor target = targetSchema.getDescriptor(j);
                if (target.getName().getLocalPart().equalsIgnoreCase(source.getName().getLocalPart()) && target.getType().getBinding().isAssignableFrom(source.getType().getBinding())) {
                    queryAttributes.put(target.getName().getLocalPart(), source.getName().getLocalPart());
                }
                ++j;
            }
            ++i;
        }
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> toFeatureCollection(final Collection<SimpleFeature> collection, SimpleFeatureType type) {
        return new AdaptorFeatureCollection("collection", type){

            protected void closeIterator(Iterator arg0) {
            }

            protected Iterator openIterator() {
                return collection.iterator();
            }

            public int size() {
                return collection.size();
            }
        };
    }

    public static Collection<SimpleFeature> copyFeature(final SimpleFeature source, final SimpleFeatureType destinationSchema, final Map<String, String> attributeMap, final MathTransform mt) {
        return new AbstractCollection<SimpleFeature>(){

            @Override
            public Iterator<SimpleFeature> iterator() {
                final HashMap geometries = new HashMap();
                final Object[] attributes = FeatureUtils.copyAttributes(destinationSchema, source, geometries, attributeMap, mt);
                return new Iterator<SimpleFeature>(){
                    SimpleFeature next;
                    SimpleFeature template;

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public boolean hasNext() {
                        if (this.template == null) {
                            try {
                                this.template = this.next = SimpleFeatureBuilder.build((SimpleFeatureType)destinationSchema, (Object[])attributes, null);
                            }
                            catch (Exception e) {
                                CorePlugin.log("", e);
                            }
                            return true;
                        }
                        if (!geometries.isEmpty()) ** GOTO lbl24
                        return false;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                this.next = SimpleFeatureBuilder.copy((SimpleFeature)this.template);
                                entries = geometries.entrySet();
                                iter = entries.iterator();
                                while (iter.hasNext()) {
                                    entry = iter.next();
                                    geom = (Geometry)((Iterator)entry.getValue()).next();
                                    this.next.setAttribute((String)entry.getKey(), (Object)FeatureUtils.access$1(geom, mt));
                                    if (((Iterator)entry.getValue()).hasNext()) continue;
                                    iter.remove();
                                }
                                return true;
                            }
                            catch (Exception e) {
                                CorePlugin.log("", e);
                            }
lbl24:
                            // 2 sources

                            ** while (this.next == null && !geometries.isEmpty())
                        }
lbl25:
                        // 1 sources

                        return false;
                    }

                    @Override
                    public SimpleFeature next() {
                        if (this.next == null) {
                            throw new IndexOutOfBoundsException("No more elements in iterator.");
                        }
                        SimpleFeature result = this.next;
                        this.next = null;
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                int size = 0;
                Iterator<SimpleFeature> iter = this.iterator();
                while (iter.hasNext()) {
                    ++size;
                    iter.next();
                }
                return size;
            }
        };
    }

    private static Object[] copyAttributes(SimpleFeatureType destSchema, SimpleFeature source, Map<String, Iterator<? extends Geometry>> geometries, Map<String, String> attributeMap, MathTransform mt) {
        Object[] attributes = new Object[destSchema.getAttributeCount()];
        int i = 0;
        while (i < attributes.length) {
            String sourceAttributeName = destSchema.getDescriptor(i).getName().getLocalPart();
            String name = attributeMap.get(sourceAttributeName);
            attributes[i] = name != null ? source.getAttribute(name) : destSchema.getDescriptor(i).getDefaultValue();
            if (attributes[i] instanceof Geometry) {
                Class geomType = destSchema.getDescriptor(i).getType().getBinding();
                if (!geomType.isAssignableFrom(attributes[i].getClass())) {
                    Collection<? extends Geometry> geom = FeatureUtils.createCompatibleGeometry((Geometry)attributes[i], geomType);
                    Iterator<? extends Geometry> giter = geom.iterator();
                    attributes[i] = giter.next();
                    if (giter.hasNext()) {
                        geometries.put(sourceAttributeName, giter);
                    }
                }
                attributes[i] = FeatureUtils.transformGeom((Geometry)attributes[i], mt);
            }
            ++i;
        }
        return attributes;
    }

    private static Geometry transformGeom(Geometry geom, MathTransform mt) {
        if (mt != null) {
            try {
                return JTS.transform((Geometry)geom, (MathTransform)mt);
            }
            catch (TransformException e) {
                CorePlugin.log("", e);
                return geom;
            }
        }
        return geom;
    }

    private static Collection<? extends Geometry> createCompatibleGeometry(Geometry geom, Class<? extends Geometry> targetType) {
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        if (FeatureUtils.nonCollectionToPoint(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.collectionToPoint(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.nonCollectionToMultiPoint(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.collectionToMultiPoint(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.simpleToLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.collectionToLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.simpleToMultiLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.collectionToMultiLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.polygonToMultiLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.polygonToLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.multiPolygonToLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.multiPolygonToMultiLine(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.simpleToPolygon(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.collectionToPolygon(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.multiPolygonToPolygon(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.simpleToMultiPolygon(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.collectionToMultiPolygon(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.polygonToMultiPolygon(geom, targetType, result)) {
            return result;
        }
        if (FeatureUtils.toLinearRing(geom, targetType, result)) {
            return result;
        }
        throw new IllegalArgumentException("do not know how transform from " + geom.getClass().getName() + " to " + targetType.getName());
    }

    private static boolean nonCollectionToPoint(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof GeometryCollection) && Point.class == targetType) {
            result.add((Geometry)geom.getCentroid());
            return true;
        }
        return false;
    }

    private static boolean collectionToPoint(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof GeometryCollection && Point.class == targetType) {
            int i = 0;
            while (i < geom.getNumGeometries()) {
                result.add((Geometry)geom.getGeometryN(i).getCentroid());
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean collectionToMultiPoint(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof GeometryCollection && MultiPoint.class == targetType) {
            Point[] points = new Point[geom.getNumGeometries()];
            int i = 0;
            while (i < geom.getNumGeometries()) {
                points[i] = geom.getGeometryN(i).getCentroid();
                ++i;
            }
            result.add((Geometry)FeatureUtils.geomBuilder.factory.createMultiPoint(points));
            return true;
        }
        return false;
    }

    private static boolean nonCollectionToMultiPoint(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof GeometryCollection) && MultiPoint.class == targetType) {
            result.add((Geometry)FeatureUtils.geomBuilder.factory.createMultiPoint(geom.getCentroid().getCoordinates()));
            return true;
        }
        return false;
    }

    private static boolean simpleToLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof Polygon) && !(geom instanceof GeometryCollection) && LineString.class == targetType) {
            result.add(geomBuilder.safeCreateGeometry(targetType, geom.getCoordinates()));
            return true;
        }
        return false;
    }

    private static boolean collectionToLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon) && geom instanceof GeometryCollection && LineString.class == targetType) {
            int i = 0;
            while (i < geom.getNumGeometries()) {
                result.add(geomBuilder.safeCreateGeometry(targetType, geom.getGeometryN(i).getCoordinates()));
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean simpleToMultiLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof Polygon) && !(geom instanceof GeometryCollection) && MultiLineString.class == targetType) {
            result.add(geomBuilder.safeCreateGeometry(targetType, geom.getCoordinates()));
            return true;
        }
        return false;
    }

    private static boolean collectionToMultiLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon) && geom instanceof GeometryCollection && MultiLineString.class == targetType) {
            LineString[] geoms = new LineString[geom.getNumGeometries()];
            int i = 0;
            while (i < geom.getNumGeometries()) {
                geoms[i] = geomBuilder.safeCreateGeometry(LineString.class, geom.getGeometryN(i).getCoordinates());
                ++i;
            }
            result.add((Geometry)FeatureUtils.geomBuilder.factory.createMultiLineString(geoms));
            return true;
        }
        return false;
    }

    private static boolean simpleToPolygon(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof Polygon) && !(geom instanceof GeometryCollection) && Polygon.class == targetType) {
            result.add(geomBuilder.safeCreateGeometry(targetType, geom.getCoordinates()));
            return true;
        }
        return false;
    }

    private static boolean collectionToPolygon(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof MultiPolygon) && geom instanceof GeometryCollection && Polygon.class == targetType) {
            int i = 0;
            while (i < geom.getNumGeometries()) {
                result.add(geomBuilder.safeCreateGeometry(targetType, geom.getGeometryN(i).getCoordinates()));
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean polygonToLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof Polygon && LineString.class == targetType) {
            Polygon polygon = (Polygon)geom;
            result.add((Geometry)geomBuilder.safeCreateGeometry(LineString.class, polygon.getExteriorRing().getCoordinates()));
            int i = 0;
            while (i < polygon.getNumInteriorRing()) {
                result.add((Geometry)geomBuilder.safeCreateGeometry(LineString.class, polygon.getInteriorRingN(i).getCoordinates()));
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean polygonToMultiLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof Polygon && MultiLineString.class == targetType) {
            ArrayList<Geometry> tmp = new ArrayList<Geometry>();
            if (!FeatureUtils.polygonToLine(geom, LineString.class, tmp)) {
                throw new RuntimeException("Huh?  multi polygons should only have polygons in them");
            }
            result.add((Geometry)FeatureUtils.geomBuilder.factory.createMultiLineString(tmp.toArray(new LineString[0])));
            return true;
        }
        return false;
    }

    private static boolean multiPolygonToLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof MultiPolygon && LineString.class == targetType) {
            int i = 0;
            while (i < geom.getNumGeometries()) {
                if (!FeatureUtils.polygonToLine(geom.getGeometryN(i), targetType, result)) {
                    throw new RuntimeException("Huh?  multi polygons should only have polygons in them");
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean multiPolygonToMultiLine(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof MultiPolygon && MultiLineString.class == targetType) {
            int i = 0;
            while (i < geom.getNumGeometries()) {
                if (!FeatureUtils.polygonToMultiLine(geom.getGeometryN(i), targetType, result)) {
                    throw new RuntimeException("Huh?  multi polygons should only have polygons in them, found a " + geom.getGeometryN(i));
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean multiPolygonToPolygon(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof MultiPolygon && Polygon.class == targetType) {
            int j = 0;
            while (j < geom.getNumGeometries()) {
                result.add(geom.getGeometryN(j));
                ++j;
            }
            return true;
        }
        return false;
    }

    private static boolean simpleToMultiPolygon(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof Polygon) && !(geom instanceof GeometryCollection) && MultiPolygon.class == targetType) {
            result.add(geomBuilder.safeCreateGeometry(targetType, geom.getCoordinates()));
            return true;
        }
        return false;
    }

    private static boolean collectionToMultiPolygon(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (!(geom instanceof Polygon) && geom instanceof GeometryCollection && MultiPolygon.class == targetType) {
            int i = 0;
            while (i < geom.getNumGeometries()) {
                result.add(geomBuilder.safeCreateGeometry(targetType, geom.getGeometryN(i).getCoordinates()));
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean polygonToMultiPolygon(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (geom instanceof Polygon && MultiPolygon.class == targetType) {
            result.add((Geometry)FeatureUtils.geomBuilder.factory.createMultiPolygon(new Polygon[]{(Polygon)geom}));
            return true;
        }
        return false;
    }

    private static boolean toLinearRing(Geometry geom, Class<? extends Geometry> targetType, Collection<Geometry> result) {
        if (targetType != LinearRing.class) {
            return false;
        }
        ArrayList<Geometry> tmp = new ArrayList<Geometry>();
        if (!(FeatureUtils.simpleToLine(geom, LineString.class, tmp) || FeatureUtils.collectionToLine(geom, LineString.class, tmp) || FeatureUtils.polygonToLine(geom, LineString.class, tmp) || FeatureUtils.multiPolygonToLine(geom, LineString.class, tmp))) {
            return false;
        }
        for (Geometry geometry : tmp) {
            result.add(geomBuilder.safeCreateGeometry(targetType, geometry.getCoordinates()));
        }
        return true;
    }

    public static Set<Identifier> stringToId(FilterFactory fac, String fid) {
        return FeatureUtils.stringToId(fac, Collections.singleton(fid));
    }

    public static Set<Identifier> stringToId(FilterFactory fac, Collection<String> fid) {
        HashSet<Identifier> ids = new HashSet<Identifier>();
        for (String string : fid) {
            ids.add((Identifier)fac.featureId(string));
        }
        return ids;
    }

    public static Filter id(String fid) {
        FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        Set<Identifier> id = FeatureUtils.stringToId((FilterFactory)factory, fid);
        Id filter = factory.id(id);
        return filter;
    }

    static /* synthetic */ Geometry access$1(Geometry geometry, MathTransform mathTransform) {
        return FeatureUtils.transformGeom(geometry, mathTransform);
    }
}

