/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.core.internal.ExtensionPointItemCreator;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ExtensionPointUtil {
    public static void process(String xpid, ExtensionPointProcessor processor) {
        ExtensionPointUtil.process(CorePlugin.getDefault(), xpid, processor);
    }

    public static void process(Plugin plugin, String xpid, ExtensionPointProcessor processor) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(xpid);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                try {
                    processor.process(extension, element);
                }
                catch (Throwable exception) {
                    plugin.getLog().log((IStatus)new Status(2, element.getNamespaceIdentifier(), 0, MessageFormat.format("Error processing extension {0}", exception), exception));
                }
                ++j;
            }
            ++i;
        }
    }

    public static List list(String xpid, ExtensionPointItemCreator itemCreator) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(xpid);
        if (extensionPoint == null) {
            return Collections.EMPTY_LIST;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                try {
                    Object obj = itemCreator.createItem(extension, element);
                    if (obj != null) {
                        list.add(obj);
                    }
                }
                catch (Throwable exception) {
                    CorePlugin.getDefault().getLog().log((IStatus)new Status(2, extension.getNamespaceIdentifier(), 0, MessageFormat.format("Error processing extension {0}", exception), exception));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }
}

