/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;

public class Data {
    public static final BufferedReader reader(Class caller, String name) throws IOException {
        URL url = Data.url(caller, name);
        if (url == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    public static final BufferedReader reader(Object host, String name) throws IOException {
        return Data.reader(host.getClass(), name);
    }

    public static final URL url(Class caller, String name) {
        return caller.getResource(name);
    }

    public static final URL url(Object caller, String name) {
        return Data.url(caller.getClass(), name);
    }

    public static final File file(Object caller, String path) throws IOException {
        File file;
        URL url = Data.url(caller, path);
        if (url != null && (file = new File(URLDecoder.decode(url.getFile(), "UTF-8"))).exists()) {
            return file;
        }
        throw new FileNotFoundException("Could not locate:" + path);
    }

    public static final File file(Class caller, String path) throws IOException {
        File file;
        URL url = Data.url(caller, path);
        if (url != null && (file = new File(URLDecoder.decode(url.getFile(), "UTF-8"))).exists()) {
            return file;
        }
        throw new FileNotFoundException("Could not locate:" + path);
    }

    public static final File temp(Object caller, String name) throws IOException {
        File testData = Data.file(caller, null);
        int split = name.lastIndexOf(46);
        String prefix = split == -1 ? name : name.substring(0, split);
        String suffix = split == -1 ? null : name.substring(split + 1);
        File tmp = File.createTempFile(prefix, suffix, testData);
        tmp.deleteOnExit();
        return tmp;
    }
}

