/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends Plugin {
    public static final String ID = "net.refractions.udig.core";
    private static CorePlugin plugin;
    public static final URLStreamHandler RELAXED_HANDLER;

    static {
        RELAXED_HANDLER = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                try {
                    URL url = new URL(u.toString());
                    return url.openConnection();
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
        };
    }

    public CorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static URL createSafeURL(String spec) {
        try {
            return new URL(null, spec, RELAXED_HANDLER);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createSafeURI(String spec) {
        try {
            return new URI(spec);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static List<URL> stringsToURLs(String string) {
        String[] strings = string.split("\n");
        return CorePlugin.stringsToURLs(strings);
    }

    public static List<URL> stringsToURLs(String[] strings) {
        ArrayList<URL> urls = new ArrayList<URL>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                urls.add(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    urls.add(new File(string).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException2) {}
            }
            ++n2;
        }
        return urls;
    }

    public static void log(String message2, Throwable e) {
        String message = message2;
        if (message == null) {
            message = "";
        }
        CorePlugin.getDefault().getLog().log((IStatus)new Status(1, ID, 0, message, e));
    }

    public static void trace(String message, Throwable e) {
        if (CorePlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isDebugging(String trace) {
        return CorePlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public static boolean isDeveloping() {
        return System.getProperty("UDIG_DEVELOPING") != null;
    }
}

