/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractRegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    private final ILog pluginLog;
    private final String pluginId;

    protected AbstractRegistryReader(ILog log, String id) {
        this.pluginLog = log;
        this.pluginId = id;
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(extension.getLabel()) + " " + extension.getNamespaceIdentifier() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        String message = buf.toString();
        this.pluginLog.log(this.newStatus(4, message, null));
        System.err.println(message);
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logMissingElement(IConfigurationElement element, String elementName) {
        this.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IStatus newStatus(int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().length() == 0) {
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, this.pluginId, severity, statusMessage, exception);
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Comparator comparer = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s1 = ((IExtension)arg0).getNamespaceIdentifier();
                String s2 = ((IExtension)arg1).getNamespaceIdentifier();
                return s1.compareToIgnoreCase(s2);
            }
        };
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                this.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    public void readRegistry(IExtensionRegistry registry, String targetPluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(targetPluginId, extensionPoint);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        extensions = this.orderExtensions(extensions);
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }
}

